/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */
 
#ifndef VAMPIRIA_PACKET_TYPES_H

#define VAMPIRIA_PACKET_TYPES_H 1

namespace vampiria { namespace packet {

//! Utility function to generate a generic string format code for ethernet(layer 2) next type(layer 3) of the form ethertype_XXXX (X is a hexadecimal code). Used for package codes not yet entered in the library.
/*!
    @param code code in numeric format
    @return  ethernet next type in string format	
*/
vmp::str ethertype_str_generic(vmp_uint16 code);

//! Ethernet type(Field used in level 2 types, to define the next header)
class DataEtherType:public packet::DataBytes
{
    private:
        vmp_uint16 data_;/*!< Type Data*/
        vmp::Table<vmp_uint16,vmp::str *> code_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp_uint16 *> strcode_;/*!<Internal usage*/

        //! Insert code
        /*!
            @param strcode code name
            @param code data code
            @return void or except to mistake
        */
        void insert_code(vmp::str strcode,vmp_uint16 code);
    public:
        //! A constructor
        /*!
            @param field data field
        */    
        DataEtherType(vmp::str field);
    
        //! A destructor
        ~DataEtherType();

	//! Virtual function
        vmp::str get(vmp::str field);
        
	//! Virtual function
        void set(vmp::str field,vmp::str data);
        
	//! Virtual function
        void read(vmp::Buf *buf);
        
	//! Virtual function
        void write(vmp::Buf *buf);

	//! Get data in raw mode
        /*!
            @return data
            @sa data_
        */
        vmp_uint16 get_data();
        
	//! Set data in raw mode
        /*!
	     @param data data value
	*/
	void set_data(vmp_uint16 data);
};

//! Utility function to generate a generic string format code for ip(layer 3) next type(layer 4)of the form ipproto_XX (X is a hexadecimal code). Used for package codes not yet entered in the library.
/*!
    @param code code in numeric format
    @return  ip proto next type in string format	
*/
vmp::str ipproto_str_generic(vmp_byte code);

//! Ip proto type(Field used in level 3 types, to define the next header)
class DataIpProto:public packet::DataBytes
{
    private:
        vmp_byte data_;/*!< Type Data*/
        vmp::Table<vmp_byte,vmp::str *> code_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp_byte *> strcode_;/*!<Internal usage*/

        //! Insert code
        /*!
            @param strcode code name
            @param code data code
            @return void or except to mistake
        */
        void insert_code(vmp::str strcode,vmp_byte code);
    public:
        //! A constructor
        /*!
            @param field data field
        */   
        DataIpProto(vmp::str field);
        
        //! A destructor
        ~DataIpProto();

        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);

        //! Get data in raw mode
        /*!
            @return data
            @sa data_
        */
        vmp_byte get_data();
        
	//! Set data in raw mode
        /*!
	     @param data data value
	*/
	void set_data(vmp_byte data);
};

//! Utility function to generate a generic string format code for arp hardware type(previous header) of the form arphtype_XXXX (X is a hexadecimal code). 
//! Used for arp subtype codes not yet entered in the library.
/*!
    @param code code in numeric format
    @return  ip proto next type in string format	
*/
vmp::str arphtype_str_generic(vmp_uint16 code);

//! Arp hardware type(previous header))
class DataArpHtype:public packet::DataBytes
{
    private:
        vmp_uint16 data_;/*!< Type Data*/
        vmp::Table<vmp_uint16,vmp::str *> code_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp_uint16 *> strcode_;/*!<Internal usage*/

         //! Insert code
        /*!
            @param strcode code name
            @param code data code
            @return void or except to mistake
        */
        void insert_code(vmp::str strcode,vmp_uint16 code);
    public:
         //! A constructor
        /*!
            @param field data field
        */   
        DataArpHtype(vmp::str label);
        
        //! A destructor
        ~DataArpHtype();

        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);

        //! Get data in raw mode
        /*!
            @return data
            @sa data_
        */
        vmp_uint16 get_data();
        
	//! Set data in raw mode
        /*!
	     @param data data value
	*/
	void set_data(vmp_uint16 data);
};

}}

#endif

