/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/09/2024
*/

#include "packet.h"

namespace vampiria { namespace packet {

DataDigit::DataDigit(vmp::str field,vmp_int min,vmp_int max):packet::DataBytes(field)
{
    data_=0;
    if(max < min)
        vmp::except("max [%d] < min [%d] in data digit",max,min);
    min_=min;
    max_=max;
}

DataDigit::~DataDigit()
{
    data_=0;
}
        
vmp::str DataDigit::get(vmp::str field)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%d",data_);
    return ret;
}
        
void DataDigit::set(vmp::str field,vmp::str data)
{
    data_= vmp::unicode::str_todigit_range(data,min_,max_);
}
        
void DataDigit::read(vmp::Buf *buf)
{
    set("",buf->read_str(buf->size_reading()));
}
        
void DataDigit::write(vmp::Buf *buf)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%d",data_);
    buf->write_str(ret);
}

void DataDigit::set_data(vmp_int data)
{
    if((data < min_) || (data > max_))
        vmp::except("Data digit input '%d' bad value",data);
    data_=data;
}
    
vmp_int DataDigit::get_data()
{
    return data_;
}

DataReal::DataReal(vmp::str field,vmp_real min,vmp_real max):packet::DataBytes(field)
{
    data_=0;
    if(max < min)
        vmp::except("max [%f] < min [%f] in data real",max,min);
    min_=min;
    max_=max;
}

DataReal::~DataReal()
{
    data_=0;
}
        
vmp::str DataReal::get(vmp::str field)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%f",data_);
    return ret;
}
        
void DataReal::set(vmp::str field,vmp::str data)
{
    data_= vmp::unicode::str_toreal_range(data,min_,max_);
}
        
void DataReal::read(vmp::Buf *buf)
{
    set("",buf->read_str(buf->size_reading()));
}
        
void DataReal::write(vmp::Buf *buf)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%f",data_);
    buf->write_str(ret);
}

void DataReal::set_data(vmp_real data)
{
    if((data < min_) || (data > max_))
        vmp::except("Data real input '%f' bad value",data);
    data_=data;
}
     
vmp_real DataReal::get_data()
{
    return data_;
}

}}

