/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 26/09/2024
*/

#include "jrp.h"

namespace vampiria { namespace jrp {

void jrpui_tcpconnectcb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();   
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    ui->set_jrp_event(cell);
    crypto::EventP2p *p2p=cell->event<crypto::EventP2p>();
    try
    {
        vmp::utils::Logger *logger=ui->logger();
        net::Address *peer=p2p->evt_connection_peeraddr();
        logger->write(vmp::utils::LOG_INFO,"%s_jrp_connect(peer='%s:%s')",p2p->evt_connection_strtype().c_str(),peer->host().c_str(),peer->service().c_str());
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->tcpconnect_(cell);   
    }
    catch(vmp::exception &x)
    {
    }
}

void jrpui_tcpacceptcb(event::Cell *cell,event::Cell *child)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=child->ui<jrp::JrpUI>();
    ui->set_jrp_event(child);
    crypto::EventP2p *p2p=child->event<crypto::EventP2p>();
    try
    {
        vmp::utils::Logger *logger=ui->logger();
        net::Address *peer=p2p->evt_connection_peeraddr();
        logger->write(vmp::utils::LOG_INFO,"%s_jrp_accept(peer='%s:%s')",p2p->evt_connection_strtype().c_str(),peer->host().c_str(),peer->service().c_str());
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->tcpaccept_(cell,child);
    }
    catch(vmp::exception &x)
    {
    }
}

void session_log(event::Cell *cell,jrp::JrpUI *ui)
{
    crypto::EventP2p *p2p=cell->event<crypto::EventP2p>();
    jrp::EventJrp *jrp=(jrp::EventJrp *)p2p->sub_;
    vmp::utils::Logger *logger=ui->logger();
    net::Address *peer=p2p->evt_connection_peeraddr();
    json::Json json;
    jrp->peersession_.json_reqdata(json.root());
    logger->write(vmp::utils::LOG_INFO,"%s_jrp_session(peer='%s:%s',subject='%s',fingerprint='%s',permits=%u,mypermits=%u,reqdata=%s)",p2p->evt_connection_strtype().c_str(),peer->host().c_str(),peer->service().c_str(),p2p->peer_.subject().c_str(),p2p->peer_.fingerprint().c_str(),p2p->peer_.permits(),jrp->peersession_.permits(),json.json_str().c_str());
}

void jrpui_csessioncb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    try
    {
        jrp::session_log(cell,ui);
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->sessionclient_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void jrpui_ssessioncb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    try
    {
        jrp::session_log(cell,ui);
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->sessionserver_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void close_log(event::Cell *cell,jrp::JrpUI *ui,vmp::str addrtype)
{
    crypto::EventP2p *p2p=cell->event<crypto::EventP2p>();
    vmp::utils::Logger *logger=ui->logger();
    net::Address *addr;
    if(addrtype == "local")
        addr=p2p->evt_connection_localaddr();
    else
        addr=p2p->evt_connection_peeraddr();
    vmp::str strtype=p2p->evt_connection_strtype();
    if(cell->ret_ == event::SUCCESS)
        logger->write(vmp::utils::LOG_INFO,"%s_jrp_close(%s='%s:%s') [level='%s','OK']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str(),cell->closelevel_.c_str());
    else if(cell->ret_ == event::TIMEOUT)
        logger->write(vmp::utils::LOG_ERR,"%s_jrp_close(%s='%s:%s') ['Timeout']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str());
    else
        logger->write(vmp::utils::LOG_ERR,"%s_jrp_close(%s='%s:%s')[level='%s',errcode=%d,errmsg='%s']",strtype.c_str(),addrtype.c_str(),addr->host().c_str(),addr->service().c_str(),cell->closelevel_.c_str(),cell->errcode_,cell->err_.c_str());
}

void jrpui_lclosecb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    try
    {
        jrp::close_log(cell,ui,"local");
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->closelisten_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void jrpui_cclosecb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    try
    {
        jrp::close_log(cell,ui,"peer");
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->closeclient_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

void jrpui_sclosecb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    jrp::JrpUI *ui=cell->ui<jrp::JrpUI>();
    try
    {
        jrp::close_log(cell,ui,"peer");
    }
    catch(vmp::exception &x)
    {
    }
    manager->unlock();
    try
    {
        ui->closeserver_(cell);
    }
    catch(vmp::exception &x)
    {
    }
}

}}

