/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 25/10/2024
 */

#include "event.h"

namespace vampiria { namespace event {

void input_ev(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    vmp::str data="";
    manager->lock();
    EventInput *evinput=cell->event<EventInput>();
    try
    {
        data=vmp::input();
        if(data != "")
            exec=(manager->cell_update(cell) && evinput->enable_);
    }
    catch(vmp::exception &x)
    {
        manager->cell_close(cell,event::ERROR,x.what());
    }
    manager->unlock();
    if(exec)
        evinput->iread_(cell,data);
}

EventInput::EventInput():event::Event()
{
    enable_=true;
}
       
EventInput::~EventInput()
{
}

event::Cell *EventInput::evt_input_new(event::UI *ui,event::EVTCBSTR iread,event::EVTCB close)
{
    if(iread == 0)
       iread_=empty_str_ev;
    else
       iread_=iread;
    return evt_new(ui,0,input_ev,close);  
}

void EventInput::evt_input_close()
{
    evt_close();
}

void EventInput::evt_input_free()
{
    iread_=0;
    evt_free();
}

}}

