/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/09/2024
 */
 
#include "crypto.h"

namespace vampiria { namespace crypto {

Ctx_Base_Tls_Client::Ctx_Base_Tls_Client():Ctx_I()
{
    build_ctx();
}

Ctx_Base_Tls_Client::~Ctx_Base_Tls_Client()
{
}

SSL_CTX *Ctx_Base_Tls_Client::init()
{
    return SSL_CTX_new(TLS_client_method());
}

Ctx_Base_Tls_Server::Ctx_Base_Tls_Server(vmp::str dircert):Ctx_I()
{
    pkey_=vmp::fs::union_path(dircert,crypto::pkeypem_);
    x509_=vmp::fs::union_path(dircert,crypto::x509pem_);
    build_ctx();
}

Ctx_Base_Tls_Server::~Ctx_Base_Tls_Server()
{
}

SSL_CTX *Ctx_Base_Tls_Server::init()
{
    SSL_CTX *ctx=SSL_CTX_new(TLS_server_method());
    if((SSL_CTX_use_PrivateKey_file(ctx,pkey_.c_str(),SSL_FILETYPE_PEM) <= 0) || (SSL_CTX_use_certificate_file(ctx,x509_.c_str(),SSL_FILETYPE_PEM) <= 0))
    {    
        SSL_CTX_free(ctx);
        vmp::except("crypto::Ctx_Base_Tls_Server::init() error '%s'",crypto::err_string().c_str());
        return 0;
    }
    return ctx;
}

}}

