/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 06/11/2024
 */

#include "pylib.h"
#include "jrp.h"

#ifndef VAMPIRIA_PY_JRP_H

#define VAMPIRIA_PY_JRP_H 1

//!Python wrapper of the c++ namespace vampiria::jrp in vmp_jrp.(see c++ doc)
/*!
    JrpCommon class in jrp/eventjrp.h:<BR>Constructor JrpCommon()<BR>
    JrpCommon member function list:<BR>set_limits(),jrp_callback(),
                                   jrp_forward_callback(),jrp_broadcast_callback(),
                                   init_session(),add_reqdata(),add_broadcastdata(),
                                   reset_session(),nodetype(),forward(),maxclientreq(),
                                   maxssrvpeer(),killwait()
*/
/*!
    Function c++ jrp/eventjrp.h:<BR>sessiontype(),sessionid(),sessionpermits()
*/
void jrp_eventjrp(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::jrp in vmp_jrp.(see c++ doc)
/*!
    JrpReq class in jrp/jrpreq.h:<BR>no Constructor<BR>
    JrpReq member function list:<BR>common(),type(),forward(),responseforward(),
                                    active_responseforward(),cell(),rid(),
                                    jdata_type(),key(),jdata_json(),jdata_root(),
                                    status(),msg(),alloc_internal(),alloc(),
                                    release_internal(),release(),push(),response(),
                                    kill(),close(),request_oper(),push_oper(),
                                    kill_oper(),send_from_oper()
*/
void jrp_jrpreq(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::jrp in vmp_jrp.(see c++ doc)
/*!
    Const c++ in jrp.h":<BR>protoname_,status_ok,status_err,status_malformed_msg,
                        status_undef_datatype,status_accessdenied,
                        status_duplexsession,status_protocolbad,
                        status_closeconnection,status_timeout,status_killed,
                        status_input_bad,status_push_bad,status_input_notmanaged,
                        status_rid_duplex,status_resource_busy,
                        status_resource_accessdenied,status_kill_notcomplete,
                        status_forward_denied,status_request_overflow,
                        min_permits,max_permits
*/
/*!
    Function c++ jrp.h:<BR>msg_status
*/
/*!
    Wrapper Cell->ui() for jrp in jrpui(cell)<BR>
    @return user interface jrp ui for cell.(The cell must be built with the JrpUI user interface)
*/
/*!
    JrpUI class in jrp.h:<BR>Constructor JrpUI(manager,ctx_peer,jrpcommon,logger=None,ctimeout=0)<BR>
    JrpUI member function list:<BR>set_p2p_client_event(),set_p2p_server_event(),
                               set_key_update(),new_client(),new_listen(),
                               localaddr(),peeraddr(),proxyinfo(),connection_type(),
                               connection_strtype(),jrpcommon(),ctx(),logger(),
                               permits(),permits_f(),get_peer_x509(),
                               peer_fingerprint(),peer_subject(),peer_permits(),
                               peer_nodetype(),peer_forward(),peer_subject_f(),
                               peer_permits_f(),peer_nodetype_f(),peer_forward_f().
                               search_peer(),search_peer_p(),
                               search_peer_o(),all_input(),all_input_f(),
                               search_input_push(),search_input_push_f(),
                               search_input_response(),search_input_response_f(),
                               search_push(),search_push_f(),search_response(),
                               search_response_f(),broadcastdata_peer(),broadcastdata_peer_f(),
                               request(),request_f(),broadcast()
*/
/*!
    Wrapper Cell->ui() for jrp in wssjrpui(cell)<BR>
    @return user interface wssjrp ui for cell.(The cell must be built with the WssJrpUI user interface)
*/
/*!
    WssJrpUI class in jrp.h:<BR>Constructor WssJrpUI(manager,ctx_peer_web,webroot,jrpcommon,logger=None,ctimeout=0)<BR>
    WssJrpUI member function list:<BR>set_http(),set_wss_event(),new_listen(),localaddr(),connection_type(),
                                      connection_strtype(),jrpcommon(),ctx(),logger(),peer_user(),peer_permits()
                                      broadcast();
*/
void jrp_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::jrp::misc in vmp_jrp.misc.(see c++ doc)
/*!
    Function c++ in jrp/misc/status.h:<BR>status_input(),status_push(),status_response()
*/
/*!
    Status class in jrp/misc/status.h:<BR>Constructor Status(dirpath,cached=true,id="")<BR>
    Status member function list:<BR>root(),backup(),keys(),update(),
                                    update_from_japi(),cancel(),cancel_from_japi(),
                                    search(),request_open(),request_close()
*/
void jrp_misc_status(pylib::Module module);

#endif

#include "eventjrp_.h"

