/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 09/10/2024
 */
 
#include "jrp_.h"

PyJrpCommon::PyJrpCommon():jrp::JrpCommon()
{
}

PyJrpCommon::~PyJrpCommon()
{
    destroy();
}

void jrpcommon_pyrequest(jrp::JrpReq *jreq,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(2);
    cargs.add<jrp::JrpReq *>(jreq,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pyrequestcb_.call(cargs);
}

void jrpcommon_pyrequesterr(jrp::JrpReq *jreq,vmp_int errcode,vmp::str msg)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(3);
    cargs.add<jrp::JrpReq *>(jreq,false);
    cargs.add<vmp_int>(errcode);
    cargs.add<vmp::str>(msg);
    common->pyrequesterrcb_.call(cargs);
}

void jrpcommon_pykill(jrp::JrpReq *jreq)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(1);
    cargs.add<jrp::JrpReq *>(jreq,false);
    common->pykillcb_.call(cargs);
}

void jrpcommon_pypush(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(3);
    cargs.add<jrp::JrpReq *>(jreq,false);
    cargs.add<json::JsonObj *>(jdata,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pypushcb_.call(cargs);
}

void jrpcommon_pyresponse(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(3);
    cargs.add<jrp::JrpReq *>(jreq,false);
    cargs.add<json::JsonObj *>(jdata,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pyresponsecb_.call(cargs);
}

void jrpcommon_pyclose(jrp::JrpReq *jreq)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(1);
    cargs.add<jrp::JrpReq *>(jreq,false);
    common->pyclosecb_.call(cargs);
}

struct stub_JrpCommon_jrp_callback:public pylib::Member_def<PyJrpCommon>
{
    pylib::Objref *def(PyJrpCommon *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 6)
        {
            jrp::JREQREQCB requestcb;
            jrp::JREQERRCB requesterrcb;
            jrp::JREQCB killcb;
            jrp::JREQDATACB pushcb;
            jrp::JREQDATACB responsecb;
            jrp::JREQCB closecb;
            args.get_callable(0,instance->pyrequestcb_);
            args.get_callable(1,instance->pyrequesterrcb_);
            args.get_callable(2,instance->pykillcb_);
            args.get_callable(3,instance->pypushcb_);
            args.get_callable(4,instance->pyresponsecb_);
            args.get_callable(5,instance->pyclosecb_);
            if(pylib::is_none(instance->pyrequestcb_.ref()))
               requestcb=0;
            else 
               requestcb=jrpcommon_pyrequest;
            if(pylib::is_none(instance->pyrequesterrcb_.ref()))
               requesterrcb=0;
            else 
               requesterrcb=jrpcommon_pyrequesterr;
            if(pylib::is_none(instance->pykillcb_.ref()))
               killcb=0;
            else 
               killcb=jrpcommon_pykill;
            if(pylib::is_none(instance->pypushcb_.ref()))
               pushcb=0;
            else 
               pushcb=jrpcommon_pypush;
            if(pylib::is_none(instance->pyresponsecb_.ref()))
               responsecb=0;
            else 
               responsecb=jrpcommon_pyresponse;
            if(pylib::is_none(instance->pyclosecb_.ref()))
               closecb=0;
            else 
               closecb=jrpcommon_pyclose;
            instance->jrp_callback(requestcb,requesterrcb,killcb,pushcb,responsecb,closecb);
            return pylib::retnone();
        }
        return 0;
    }
};

void jrpcommon_pyrequestforward(jrp::JrpReq *jreq,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(2);
    cargs.add<jrp::JrpReq *>(jreq,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pyrequestforwardcb_.call(cargs);
}

void jrpcommon_pypushforward(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(3);
    cargs.add<jrp::JrpReq *>(jreq,false);
    cargs.add<json::JsonObj *>(jdata,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pypushforwardcb_.call(cargs);
}

void jrpcommon_pyresponseforward(jrp::JrpReq *jreq,json::JsonObj *jdata,vmp::Buf *payload)
{
    PyJrpCommon *common=(PyJrpCommon *) jreq->common();
    pylib::CArgs cargs(3);
    cargs.add<jrp::JrpReq *>(jreq,false);
    cargs.add<json::JsonObj *>(jdata,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pyresponseforwardcb_.call(cargs);
}

struct stub_JrpCommon_jrp_forward_callback:public pylib::Member_def<PyJrpCommon>
{
    pylib::Objref *def(PyJrpCommon *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            jrp::JREQREQCB  requestcb;
            jrp::JREQDATACB pushcb;
            jrp::JREQDATACB responsecb;
            args.get_callable(0,instance->pyrequestforwardcb_);
            args.get_callable(1,instance->pypushforwardcb_);
            args.get_callable(2,instance->pyresponseforwardcb_);
            if(pylib::is_none(instance->pyrequestforwardcb_.ref()))
               requestcb=0;
            else 
               requestcb=jrpcommon_pyrequestforward;
            if(pylib::is_none(instance->pypushforwardcb_.ref()))
               pushcb=0;
            else 
               pushcb=jrpcommon_pypushforward;
            if(pylib::is_none(instance->pyresponseforwardcb_.ref()))
               responsecb=0;
            else 
               responsecb=jrpcommon_pyresponseforward;
            instance->jrp_forward_callback(requestcb,pushcb,responsecb);
            return pylib::retnone();
        }
        return 0;
    }
};

void jrpcommon_pybroadcast(event::Cell *cell,json::JsonObj *jdata,vmp::Buf *payload)
{
    jrp::EventJrp *jrp=(jrp::EventJrp *)cell->event<crypto::EventSsl>()->sub_;
    PyJrpCommon *common=(PyJrpCommon *) jrp->common_;
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<json::JsonObj *>(jdata,false);
    if(payload == 0)
        cargs.add<pylib::Objref *>(pylib::retnone());
    else
        cargs.add<vmp::Buf *>(payload,false);
    common->pybroadcastcb_.call(cargs);
}

struct stub_JrpCommon_jrp_broadcast_callback:public pylib::Member_def<PyJrpCommon>
{
    pylib::Objref *def(PyJrpCommon *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            jrp::JBROADCASTCB broadcastcb;
            args.get_callable(0,instance->pybroadcastcb_);
            if(pylib::is_none(instance->pybroadcastcb_.ref()))
               broadcastcb=0;
            else 
               broadcastcb=jrpcommon_pybroadcast;
            instance->jrp_broadcast_callback(broadcastcb);
            return pylib::retnone();   
        }
        return 0;
    }
};

struct stub_JrpCommon_init_session:public pylib::Member_def<PyJrpCommon>
{
    pylib::Objref *def(PyJrpCommon *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str nodetype=args.get<vmp::str>(0);
            instance->init_session(nodetype);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            vmp::str nodetype=args.get<vmp::str>(0);
            vmp_bool forward=args.get<vmp_bool>(1);
            instance->init_session(nodetype,forward);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_JrpCommon_add_reqdata:public pylib::Member_def<PyJrpCommon>
{
    pylib::Objref *def(PyJrpCommon *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            vmp::str input=args.get<vmp::str>(0);
            vmp::vector<vmp::str> push=args.get<vmp::vector<vmp::str> >(1);
            vmp::vector<vmp::str> response=args.get<vmp::vector<vmp::str> >(2);
            instance->add_reqdata(input,push,response);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            vmp::str input=args.get<vmp::str>(0);
            vmp::vector<vmp::str> push=args.get<vmp::vector<vmp::str> >(1);
            vmp::vector<vmp::str> response=args.get<vmp::vector<vmp::str> >(2);
            vmp::str permits=args.get<vmp::str>(3);
            instance->add_reqdata(input,push,response,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

void jrp_eventjrp(pylib::Module module)
{
    pylib::Class<PyJrpCommon> jrpcommon=module.class_<PyJrpCommon>("JrpCommon");
    jrpcommon.def_("set_limits",&PyJrpCommon::set_limits);
    jrpcommon.def_with_stub("jrp_callback",stub_JrpCommon_jrp_callback());
    jrpcommon.def_with_stub("jrp_forward_callback",stub_JrpCommon_jrp_forward_callback());
    jrpcommon.def_with_stub("jrp_broadcast_callback",stub_JrpCommon_jrp_broadcast_callback());
    jrpcommon.def_with_stub("init_session",stub_JrpCommon_init_session());
    jrpcommon.def_with_stub("add_reqdata",stub_JrpCommon_add_reqdata());
    jrpcommon.def_("add_broadcastdata",&PyJrpCommon::add_broadcastdata);
    jrpcommon.def_("reset_session",&PyJrpCommon::reset_session);
    jrpcommon.def_("nodetype",&PyJrpCommon::nodetype);
    jrpcommon.def_("forward",&PyJrpCommon::forward);
    jrpcommon.def_("maxclientreq",&PyJrpCommon::maxclientreq);
    jrpcommon.def_("maxssrvpeer",&PyJrpCommon::maxssrvpeer);
    jrpcommon.def_("killwait",&PyJrpCommon::killwait);
    module.def_("sessiontype",jrp::sessiontype);
    module.def_("sessionid",jrp::sessionid);
    module.def_("sessionpermits",jrp::sessionpermits);
}

