/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 06/09/2024
 */
 
#include "crypto_.h"

struct stub_md5:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::md5(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::md5(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_md5_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::md5_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::md5_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

struct stub_sha1:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::sha1(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha1(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_sha1_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::sha1_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha1_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

struct stub_sha224:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::sha224(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha224(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_sha224_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::sha224_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha224_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

struct stub_sha256:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::sha256(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha256(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_sha256_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::sha256_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha256_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

struct stub_sha384:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::sha384(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha384(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_sha384_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::sha384_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha384_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

struct stub_sha512:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::str istr=args.get<vmp::str>(0);
             return pylib::Converter<vmp::str>(crypto::sha512(istr));
         }
         else if(args.size() == 2)
         {
             vmp::str istr=args.get<vmp::str>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha512(istr,delimiter));
         }     
         return 0;
    }
};

struct stub_sha512_bin:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             return pylib::Converter<vmp::str>(crypto::sha512_bin(ibuf));
         }
         else if(args.size() == 2)
         {
             vmp::Buf *ibuf=args.get<vmp::Buf *>(0);
             vmp::str delimiter=args.get<vmp::str>(1);
             return pylib::Converter<vmp::str>(crypto::sha512_bin(ibuf,delimiter));
         }     
         return 0;
    }
};

void crypto_hash(pylib::Module module)
{
    module.def_with_stub("md5",stub_md5());
    module.def_with_stub("md5_bin",stub_md5_bin());
    module.def_with_stub("sha1",stub_sha1());
    module.def_with_stub("sha1_bin",stub_sha1_bin());
    module.def_with_stub("sha224",stub_sha224());
    module.def_with_stub("sha224_bin",stub_sha224_bin());
    module.def_with_stub("sha256",stub_sha256());
    module.def_with_stub("sha256_bin",stub_sha256_bin());
    module.def_with_stub("sha384",stub_sha384());
    module.def_with_stub("sha384_bin",stub_sha384_bin());
    module.def_with_stub("sha512",stub_sha512());
    module.def_with_stub("sha512_bin",stub_sha512_bin());
}

