/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 02/10/2024
 */
 
#include "crypto_.h"

struct Ctx_Base_Tls_Server_stub_Constructor:public pylib::Constructor<crypto::Ctx_Base_Tls_Server>
{
    crypto::Ctx_Base_Tls_Server *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            return new crypto::Ctx_Base_Tls_Server(dircert);
        }
        return 0;
    }
};

struct Ctx_Https_Tls_stub_Constructor:public pylib::Constructor<crypto::Ctx_Https_Tls>
{
    crypto::Ctx_Https_Tls *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp::str subject=args.get<vmp::str>(1);
            return new crypto::Ctx_Https_Tls(dircert,subject);
        }
        else if(args.size() == 3)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp::str subject=args.get<vmp::str>(1);
            vmp_uint days=args.get<vmp_uint>(2);
            return new crypto::Ctx_Https_Tls(dircert,subject,days);
        }
        return 0;
    }
};

struct Ctx_Peer_stub_Constructor:public pylib::Constructor<crypto::Ctx_Peer>
{
    crypto::Ctx_Peer *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp_uint defp=args.get<vmp_uint>(1);
            vmp::str subject=args.get<vmp::str>(2);
            return new crypto::Ctx_Peer(dircert,defp,subject);
        }
        else if(args.size() == 4)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp_uint defp=args.get<vmp_uint>(1);
            vmp::str subject=args.get<vmp::str>(2);
            vmp_uint days=args.get<vmp_uint>(3);
            return new crypto::Ctx_Peer(dircert,defp,subject,days);
        }
        return 0;
    }
};

struct stub_Ctx_Peer_verify_acl_peer:public pylib::Member_def<crypto::Ctx_Peer>
{
    pylib::Objref *def(crypto::Ctx_Peer *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
            return pylib::Converter<vmp_uint>(instance->verify_acl_peer(args.get<vmp::str>(0)));
        else if(args.size() == 2)
            return pylib::Converter<vmp_uint>(instance->verify_acl_peer(args.get<vmp::str>(0),args.get<vmp::str>(1)));
        return 0;
    }
};

struct Ctx_Peer_Web_stub_Constructor:public pylib::Constructor<crypto::Ctx_Peer_Web>
{
    crypto::Ctx_Peer_Web *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            crypto::Ctx_Peer *peer=args.get<crypto::Ctx_Peer *>(0);
            return new crypto::Ctx_Peer_Web(peer);
        }
        return 0;
    }
};

struct stub_Ctx_Peer_Web_add_acl_user:public pylib::Member_def<crypto::Ctx_Peer_Web>
{
    pylib::Objref *def(crypto::Ctx_Peer_Web *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_uint permits=args.get<vmp_uint>(2);
            vmp_bool only_localhost=args.get<vmp_bool>(3);
            instance->add_acl_user(user,password,permits,only_localhost);
            return pylib::retnone();
        }
        else if(args.size() == 5)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_uint permits=args.get<vmp_uint>(2);
            vmp_bool only_localhost=args.get<vmp_bool>(3);
            vmp_bool md5_password=args.get<vmp_bool>(4);
            instance->add_acl_user(user,password,permits,only_localhost,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_Ctx_Peer_Web_change_password:public pylib::Member_def<crypto::Ctx_Peer_Web>
{
    pylib::Objref *def(crypto::Ctx_Peer_Web *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            instance->change_password(user,password);
            return pylib::retnone();
        }
        else if(args.size() == 3)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_bool md5_password=args.get<vmp_bool>(2);
            instance->change_password(user,password,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_Ctx_Peer_Web_verify_acl_user:public pylib::Member_def<crypto::Ctx_Peer_Web>
{
    pylib::Objref *def(crypto::Ctx_Peer_Web *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_bool islocalhost=args.get<vmp_bool>(2);
            instance->verify_acl_user(user,password,islocalhost);
            return pylib::retnone();
        }
        else if(args.size() == 4)
        {
            vmp::str user=args.get<vmp::str>(0);
            vmp::str password=args.get<vmp::str>(1);
            vmp_bool islocalhost=args.get<vmp_bool>(2);
            vmp_bool md5_password=args.get<vmp_bool>(3);
            instance->verify_acl_user(user,password,islocalhost,md5_password);
            return pylib::retnone();
        }
        return 0;
    }
};

void crypto_ctx(pylib::Module module)
{
    pylib::Class<crypto::Ctx> ctx=module.class_no_constructor<crypto::Ctx>("Ctx");
    ctx.def_("get_x509",&crypto::Ctx::get_x509); 
    
    pylib::Class<crypto::Ctx_Base_Tls_Client> btls_client=module.class_<crypto::Ctx_Base_Tls_Client>("Ctx_Base_Tls_Client");
    btls_client.def_("get",&crypto::Ctx_Base_Tls_Client::get,false);
    
    pylib::Class<crypto::Ctx_Base_Tls_Server> btls_server=module.class_with_constructor<crypto::Ctx_Base_Tls_Server>("Ctx_Base_Tls_Server",Ctx_Base_Tls_Server_stub_Constructor());
    btls_server.def_("get",&crypto::Ctx_Base_Tls_Server::get,false);
    
    pylib::Class<crypto::Ctx_Https_Tls> https_tls=module.class_with_constructor<crypto::Ctx_Https_Tls>("Ctx_Https_Tls",Ctx_Https_Tls_stub_Constructor());
    https_tls.def_("get",&crypto::Ctx_Https_Tls::get,false);
    
    pylib::Class<crypto::Ctx_Peer_Acl> pacl=module.class_<crypto::Ctx_Peer_Acl>("Ctx_Peer_Acl");
    pacl.def_("fingerprint",&crypto::Ctx_Peer_Acl::fingerprint);
    pacl.def_("subject",&crypto::Ctx_Peer_Acl::subject);
    pacl.def_("permits",&crypto::Ctx_Peer_Acl::permits);
    
    pylib::Class<crypto::Ctx_Peer> peer=module.class_with_constructor<crypto::Ctx_Peer>("Ctx_Peer",Ctx_Peer_stub_Constructor());
    peer.def_("get",&crypto::Ctx_Peer::get,false);
    peer.def_("get_x509",&crypto::Ctx_Peer::get_x509);
    peer.def_("subject",&crypto::Ctx_Peer::subject);
    peer.def_("fingerprint",&crypto::Ctx_Peer::fingerprint);
    peer.def_("defp",&crypto::Ctx_Peer::defp);
    peer.def_("add_acl_peer",&crypto::Ctx_Peer::add_acl_peer);
    peer.def_("change_permits",&crypto::Ctx_Peer::change_permits);
    peer.def_("reset_acl",&crypto::Ctx_Peer::reset_acl);
    peer.def_("del_acl_peer",&crypto::Ctx_Peer::del_acl_peer);
    peer.def_("fingerprints_acl_peer",&crypto::Ctx_Peer::fingerprints_acl_peer);
    peer.def_("get_acl_subject",&crypto::Ctx_Peer::get_acl_subject);
    peer.def_with_stub("verify_acl_peer",stub_Ctx_Peer_verify_acl_peer());
    peer.def_("verify_peer",&crypto::Ctx_Peer::verify_peer);
    peer.def_("print_acl",&crypto::Ctx_Peer::print_acl);
    
    pylib::Class<crypto::Ctx_Peer_Web> peerweb=module.class_with_constructor<crypto::Ctx_Peer_Web>("Ctx_Peer_Web",Ctx_Peer_Web_stub_Constructor());
    peerweb.def_("get",&crypto::Ctx_Peer_Web::get,false);
    peerweb.def_("peer",&crypto::Ctx_Peer_Web::peer,false);
    peerweb.def_with_stub("add_acl_user",stub_Ctx_Peer_Web_add_acl_user());
    peerweb.def_with_stub("change_password",stub_Ctx_Peer_Web_change_password());
    peerweb.def_("change_permits",&crypto::Ctx_Peer_Web::change_permits);
    peerweb.def_("reset_acl_users",&crypto::Ctx_Peer_Web::reset_acl_users);
    peerweb.def_("del_acl_user",&crypto::Ctx_Peer_Web::del_acl_user);
    peerweb.def_("list_acl_users()",&crypto::Ctx_Peer_Web::list_acl_users);
    peerweb.def_("get_md5_password",&crypto::Ctx_Peer_Web::get_md5_password);
    peerweb.def_("get_only_localhost",&crypto::Ctx_Peer_Web::get_only_localhost);
    peerweb.def_("get_permits",&crypto::Ctx_Peer_Web::get_permits);
    peerweb.def_with_stub("verify_acl_user",stub_Ctx_Peer_Web_verify_acl_user());
    peerweb.def_("print_acl_users",&crypto::Ctx_Peer_Web::print_acl_users);
}

