#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 24/03/2018

import vmpsys    as sys
import vmpconfig as config

##Helper utility for python main program:print helper<BR
#
#@param progname main program name<BR>
#@param options  tuple list options.(ex [("install sub","-s),....("install plugin,"-p plugname")]
def help(progname,options):
  lprogname=len(progname)
  lpy=len(config.python_)
  maxlength=lprogname
  l=len(config.author_)
  if l  > maxlength:
    maxlength=l
  l=len(config.license_)
  if l > maxlength:
    maxlength=l
  maxf=0
  for v in options:  
    lf=len(v[0])
    if lf > maxf:
      maxf=lf
  lp=lpy+lprogname+3
  for v in options:
    l=maxf+lp+len(v[1])  
    if l > maxlength:
      maxlength=l
  l=(int)((maxlength-lprogname)/2)
  sys.stderr("{0}{1}{2}".format("*" * l,progname,"*" * (maxlength-l-lprogname)))
  sys.stderr(config.author_)
  sys.stderr(config.license_)
  for v in options:
    ls=maxf-len(v[0])+1
    sys.stderr("{0}{1}{2} {3} {4}".format(v[0]," " * ls,config.python_,progname,v[1]))
  sys.stderr("*" * maxlength)
  sys.exit_failure()

