#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 02/10/2024

import vmppylib  as pylib
import vmpsys    as sys
import vmpconfig as config
import vmpcheck  as check

##Setup Python installer object
class pysetup:
  def __init__(self):
    ##Internal library or package dependencies ['vmp_net',...](Python).'vmp'is added by default
    self.dependencies=[]
    ##Command external ['ls -l',...]
    self.cmd=[]
    ##Internal use to avoid entering multiple dependencies of the same type
    self.deprun={}

##Build python software<BR>
#
#@param pysetup generic class pysetup value
def pybuild(pysetup):
  pylib.pydependencies(pysetup.dependencies,pysetup)
  for c in pysetup.cmd:
    sys.search_cmd(c.split())
  try:
    check.pyruntest()
  except Exception as e:
    raise sys.msg_failure("Build Python Software",str(e))
  sys.msg_ok("Build Python Software")

##Remove python software<BR>
#
#@param pysetup generic class pysetup value
def pyclear(pysetup):
  pass
  
