#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 06/11/2024

import vmpsys    as sys
import vmpconfig as config

##javascript library installed
jlibs_={}

##Check and install javascript dependencies(internal javascript lib)<BR>
#
#@param depends dependencies list<BR>
#@param pysetup generic class jsetup value
def jdependencies(depends,jsetup):
  for d in depends:
    if d in jlibs_:
      if not d in jsetup.deprun:
        jlibs_[d].install(jsetup)
    else:
      sys.msg_failure("Javascript lib \'{0}\'".format(d),'not found')
 
##Library installer javascript 
class jlib:
  def __init__(self):
    ##Library name
    self.name=''
    #if false framework librari,otherwise package library
    self.pkg=False
    ##Internal javascript library dependencies ['vmp',...]
    self.dependencies=[]
    ##internal usage for create name.html file(css file).Root directory library path
    self.css=[]
    ##internal usage for create name.html file(javascript file).Root directory library path
    self.js=[]

  ##Install library<BR>
  #
  #@param jsetup generic class pysetup value
  def install(self,jsetup):
    jsetup.deprun[self.name]=self
    jdependencies(self.dependencies,jsetup)
    try:
      src=config.frm_jsrootlib(self.name,self.pkg)
      dst="{0}{1}/".format(jsetup.libpath,self.name)
      sys.cp_all(src,dst)
      for css in self.css:
        jsetup.csspath.append("{0}{1}/{2}".format(config.jlib_,self.name,css))
      for js in self.js:
        jsetup.jspath.append("{0}{1}/{2}".format(config.jlib_,self.name,js))
    except Exception as e:
      sys.msg_failure("Build Javascript lib \'{0}\'\n".format(self.name),e)
    sys.msg_ok("Build Javascript Lib \'{0}\'".format(self.name))

img=jlib()
img.name='img'
jlibs_[img.name]=img

vmp=jlib()
vmp.name='vmp'
vmp.dependencies=['img']
vmp.css=['vmp.css']
vmp.js=['lib.js','japi.js','jrp.js','cmp.js','main.js']
jlibs_[vmp.name]=vmp



