#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 05/04/2024

import vmpsys     as sys
import vmpconfig  as config
import vmputils   as utils
import vmpcheck   as check
import vmplib     as lib
import vmppylib   as pylib

config.pyenv()

import vpkg

##Uninstall software<BR>
def software_uninstall(dirpath):
  setup= sys.setup_import()
  sys.reload_module(setup)
  setup.uninstall()
  if check.check_installed(dirpath):
    sys.rm_file(config.ginstalled_(dirpath))
    return True
  return False  

##Uninstall all software
def software_uninstall_all():
  for l in sys.listdir(sys.path(config.gsoftware_)):
    root=config.gsoftware_path(l)
    if sys.isdir(sys.path(root)):
      config.pyhome_add(root)
      if software_uninstall(sys.path(root)):
        sys.msg_ok("Software uninstall \'{0}\'".format(l))  
      config.pyhome_remove(root)
    
##Uninstall all modules<BR>
def modules_uninstall_all():
  for l in sys.listdir(sys.path(config.gmodules_)):
    root=config.gmodule_main_(l)
    if sys.isdir(sys.path(root)):
      config.pyhome_add(root)
      if software_uninstall(sys.path(root)):
        sys.msg_ok("Module uninstall \'{0}\'".format(l))  
      config.pyhome_remove(root)
      
##Erase files that need to be deleted when uninstalling<BR>
def remove_uninstall():
  sys.system("rm -rf {0}* > /dev/null 2>&1".format(sys.path(config.fwdoc_)))
  sys.system("rm -rf {0}* > /dev/null 2>&1".format(sys.path(config.glib_)))
  
help_=[
       ("Uninstall vampiria framework(full uninstall):","-f"),
       ("Uninstall vampiria framework(partial uninstall,home data not delete):","-p"),
       ("helper:","-h")
      ]

if __name__ == "__main__":
  args=sys.argv_get()
  l=len(args)
  if l == 1 and (args[0] == '-f' or args[0] == '-p'):
    try:
      if args[0] == '-f':
        sys.rm_dir_all(sys.path(config.ghome_))
      lib.clear()
      pylib.clear()
      software_uninstall_all()
      modules_uninstall_all()
      remove_uninstall()
      sys.system(config.pyclean_cmd_)
      sys.exit_ok()
    except Exception as e:
      sys.msg_failure("Uninstall error",str(e))
  utils.help(config.uninstaller_,help_)


