/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/04/2024
*/
 
namespace vampiria { namespace web { namespace pkg {

//!Class shared by wss events used for connection table and callbacks to execute.
class WssCommon:public event::UI
{
    public:
        //! A Constructor
        WssCommon(event::Manager *manager,web::pkg::Ctx_Peer_Web *ctx);

        //! A Destructor
        ~WssCommon();
        
        openssl::pkg::Ctx_Peer_Web *ctx_;/*!<Context local peer associated*/
        vmp_uint backlog_;/*!<The maximum length to which the queue of pending  connections for every listen connections(default 24)*/
        vmp::time::Time ctimeout_;/*!<Connection timeout(Default 3.0)*/
        vmp::time::Time stimeout_;/*!<Time interval to active event timer for session jrp(default 5.0)*/
        
        net::EVTCBACCEPT tcpaccept_;/*!<Function performed when connection tcp is accepted from listen connections*/
        
        event::EVTCB wsssession_;/*!<Call when a web socket session has been created*/
        event::EVTCBBUF recv_;/*!<Function performed when a complete package was received by websocket*/
        event::EVTCB lclose_;/*!<Function performed at the end listen event*/
        event::EVTCB close_;/*!<Function performed at the end of the event*/
        
        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
 
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);
};

//!A p2p event ssl
class EventWss:public openssl::pkg::EventSsl
{
    protected:
        //! Reset Ssl event
        void evt_wss_reset();
    public:
        //! A Constructor
        EventWss();

        //! A Destructor
        ~EventWss();
        
        vmp::time::Time timetmp_;/*!<Internal usage.Stores the timeout time during the session*/
        
        web::pkg::WssCommon *common_;/*!<Shared wss class*/
        event::Cell *timer_;/*!<Internal usage,timer event*/
        vmp::str user_;/*!<User associated with the connection*/
        vmp_uint permits_;/*!<Permissions associated with the connection*/
        
        //!Create a new event wss server
        /*!
            @param ui user interface (see Class UI)
            @param local address to listen server connection
            @param common shared p2p class
            @return the new cell associated with the event or except in case of failure
        */
        event::Cell *evt_wss_server(event::UI *ui,net::Address *local,web::pkg::WssCommon *common);
        
        //! Close event
        void evt_wss_close();
       
        //! Free event
        void evt_wss_free();

};

}}}

#endif

