/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/04/2024
 */

#include "web0/web0.h"

namespace vampiria { namespace web { namespace pkg {

WssCommon::WssCommon(event::Manager *manager,web::pkg::Ctx_Peer_Web *ctx):event::UI(manager)
{
    vmp::except_check_pointer((void *)ctx,"web::pkg::WssCommon(ctx=Null)");
    ctx_=ctx;
    backlog_=24;
    ctimeout_=3.0;
    stimeout_=5.0;
    tcpaccept_=net::empty_accept_ev;
    wsssession_=event::empty_ev;
    recv_=event::empty_buf_ev;
    lclose_=event::empty_ev;
    close_=event::empty_ev;
}

WssCommon::~WssCommon()
{
}

vmp::str WssCommon::identity(event::Cell *cell)
{
}
 
void WssCommon::close_event(event::Cell *cell)
{
}
        
void WssCommon::free_ref(event::Cell *cell)
{
}

EventWss::EventWss():openssl::pkg::EventSsl()
{
    timer_=0;
    evt_wss_reset();
}

EventWss::~EventWss()
{
}

void EventWss::evt_wss_reset()
{
    if(timer_ != 0)
    {
        event::Manager *manager=timer_->get_manager();
        manager->cell_release(timer_);
    }
    timetmp_=0;
    timer_=0;
    common_=0;
    user_="";
    permits_=0;
}

event::Cell *EventWss::evt_wss_server(event::UI *ui,net::Address *local,web::pkg::WssCommon *common)
{
    vmp::except_check_pointer((void *)common,"web::pkg::EventWss::evt_wss_server(common=Null)");
    common_=common;
    return evt_ssl_listen(ui,local,common->backlog_,common->ctx_->get(),web::pkg::wss_tcp_acceptcb,common->lclose_,web::pkg::wss_sessioncb,web::pkg::wss_recv_httpcb,common->close_,common->ctimeout_);
}
        
void EventWss::evt_wss_close()
{
    if(timer_ != 0)
    {
        event::Manager *manager=timer_->get_manager();
        manager->cell_close(timer_,event::SUCCESS);
    }
    evt_ssl_close();
}
       
void EventWss::evt_wss_free()
{
    evt_p2p_reset();
    evt_ssl_free();
}

}}}

