/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/04/2024
 */
 
#ifndef VAMPIRIA_WEB_PKG_CTX_H

#define VAMPIRIA_WEB_PKG_CTX_H 1

namespace vampiria { namespace web { namespace pkg {

//!Builds peer web context generic(openssl::pkg::Ctx_peer extensions)
class Ctx_Peer_Web:public openssl::pkg::Ctx_I
{
    private:
        openssl::pkg::Ctx_Peer *peer_;/*!<Context peer openssl associated*/
        
        //! Virtual function
        SSL_CTX *init();
    public:
        //! A constructor
        /*!
            @param peer openssl::pkg::Ctx_peer to which it refers
        */
        Ctx_Peer_Web(openssl::pkg::Ctx_Peer *peer);

        //! A destructor
        ~Ctx_Peer_Web();
        
        //! Add or edit an user in acl
        /*!
            @param user user added or modified
            @param password user password
            @param permits user permits
            @param only_localhost if true, access to this user is only allowed from localhost
            @param md5_password if true the input password parameter is encrypted with the md5 function,default false
            @return void or except in case of failure
        */
        void add_acl_user(vmp::str user,vmp::str password,vmp_uint permits,vmp_bool only_localhost,vmp_bool md5_password=false);
        
        //! Reset acl user table database
       void reset_acl_users();
       
       //! Delete an user to the permissions acl
       /*!
           @param user user cancel
       */
       void del_acl_user(vmp::str user);
       
       //! Returns the list of users contained in the acl peer
       /*!
           @return fingerprint list
       */
       vmp::vector<vmp::str> list_acl_users();
       
       //! Returns a user's permissions to the acl
       /*!
           @param user user added or modified
           @param password user password
           @param islocalhost is localhost connection
           @param md5_password if true the input password parameter is encrypted with the md5 function,default false
           @return permits associated(0 no permits)
       */
       vmp_uint verify_acl_user(vmp::str user,vmp::str password,vmp_bool islocalhost,vmp_bool md5_password=false);
};
    
}}}

#endif

