/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 09/04/2024
 */

#include "web0/web0.h"

namespace vampiria { namespace web { namespace pkg {

void wss_tcp_acceptcb(event::Cell *cell,event::Cell *child)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    web::pkg::EventWss *parent=cell->event<web::pkg::EventWss>();
    web::pkg::EventWss *wss=child->event<web::pkg::EventWss>();
    wss->common_=parent->common_;
    manager->unlock();
    wss->common_->tcpaccept_(cell,child);
}

void wss_sessioncb(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    web::pkg::EventWss *wss=cell->event<web::pkg::EventWss>();
    wss->timetmp_=cell->timewait_;
    manager->cell_timewait(cell,wss->common_->stimeout_);
    manager->unlock();   
}

void wss_recv_httpcb(event::Cell *cell,vmp::Buf *buf)
{
    vmp_bool exec_=false;
    event::Manager *manager=cell->get_manager();
    manager->lock();
    web::pkg::EventWss *wss=cell->event<web::pkg::EventWss>();
    /*
        Leggi la richiesta http,se valida ritorna il valore esatto la
        conferma,attiva il framing, altrimenti manda errore e chiudi con errore
        manager->cell_timewait(cell,wss->timetmp_); e attiva timer
    */
    manager->unlock();
    if(exec_)
        wss->common_->wsssession_(cell);
}

void wss_event_framecb(event::Cell *cell)
{
    /*framing event in lettura e scrittura*/
}

}}}

