/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */
 
#include "rawnet_.h"

class PyRawNetUI:public rawnet::pkg::RawNetUI
{
   public:
        PyRawNetUI(event::Manager *manager);
        ~PyRawNetUI();

        pylib::PyCall pyrecv_;
        pylib::PyCall pycevent_;
};

PyRawNetUI::PyRawNetUI(event::Manager *manager):rawnet::pkg::RawNetUI(manager)
{
}

PyRawNetUI::~PyRawNetUI()
{
}

struct stub_rawnetui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyRawNetUI *>(cell->ui<PyRawNetUI>(),false);
        }
        return 0;
    }
};

struct RawNetUI_Constructor:public pylib::Constructor<PyRawNetUI>
{
    PyRawNetUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyRawNetUI(manager);
         }
         return 0;
    }
};

void rawnet_pyrecv(event::Cell *cell,vmp::Buf *buf)
{
    PyRawNetUI *rawnetui=cell->ui<PyRawNetUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    rawnetui->pyrecv_.call(cargs);
}

void rawnet_pycevent(event::Cell *cell)
{
    PyRawNetUI *rawnetui=cell->ui<PyRawNetUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    rawnetui->pycevent_.call(cargs);
}

struct stub_RawNetUI_set_event:public pylib::Member_def<PyRawNetUI>
{
    pylib::Objref *def(PyRawNetUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            event::EVTCBBUF recv;
            event::EVTCB   cevent;

            args.get_callable(0,instance->pyrecv_);
            args.get_callable(1,instance->pycevent_);
            
            if(pylib::is_none(instance->pyrecv_.ref()))
                recv=0;
            else 
                recv=rawnet_pyrecv;
            if(pylib::is_none(instance->pycevent_.ref()))
                cevent=0;
            else 
                cevent=rawnet_pycevent;

            instance->set_event(recv,cevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void rawnet_rawui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("rawnetui",stub_rawnetui());
	
    pylib::Class<PyRawNetUI> rawnetui=module.class_with_constructor<PyRawNetUI>("RawNetUI",RawNetUI_Constructor());
    rawnetui.def_with_stub("set_event",stub_RawNetUI_set_event());
    rawnetui.def_("new_rawnet",&PyRawNetUI::new_rawnet,false);
    rawnetui.def_("new_rawnet_w",&PyRawNetUI::new_rawnet_w,false);
    rawnetui.def_("start_read",&PyRawNetUI::start_read);
    rawnetui.def_("inject",&PyRawNetUI::inject);
    rawnetui.def_("ifname",&PyRawNetUI::ifname);
    rawnetui.def_("filter",&PyRawNetUI::filter);
    rawnetui.def_("mode",&PyRawNetUI::mode);
    rawnetui.def_("linktype",&PyRawNetUI::linktype);
    rawnetui.def_("linktype_str",&PyRawNetUI::linktype_str);
}

