/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 17/01/2023
 */
 
#include "pylib.h"
#include "rawnet3/rawnet3.h"
 
#ifndef VAMPIRIA_PY_RAWNET_H

#define VAMPIRIA_PY_RAWNET_H 1

//!Python wrapper of the c++ namespace vampiria::rawnet::pkg in vmp_rawnet{version}.(see c++ doc)
/*!
    Dumper class in rawnet{version}/rawnet{version}.h(pkg):<BR>Constructor Dumper()<BR>
    Dumper member function list:<BR>open(),dump(),close()
*/
/*!
    Offline class in rawnet{version}/rawnet/offline{version}.h(pkg):<BR>Constructor Offline()<BR>
    Offline member function list:<BR>reset(),read(),data_size(),get()
*/
/*!
    Function c++ in rawnet{version}/rawnet{version}.h(pkg):<BR> filter_file(),linktype_str_generic(),linktype_str()
*/
void rawnet_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::rawnet::pkg::RawNetUI in vmp_rawnet{version}.RawNetUI(see c++ doc)
/*!
    Wrapper Cell->ui() for rawnet in rawnetui(cell)<BR>
    @return user interface rawnet ui for cell.(The cell must be built with the RawNetUI user interface)
*/
/*!
    RawNetUI class in rawnet{version}/rawnet/rawui.h(pkg):<BR>Constructor RawNetUI(manager)<BR>
    RawNetUI member function list:<BR>set_event(),new_rawnet(),new_rawnet_w(),
                                      start_read(),inject(),ifname(),filter(),
                                      mode(),linktype(),linktype_str()
    
*/
void rawnet_rawui(pylib::Module module);

//!Python wrapper of the c++ class vampiria::rawnet::pkg::Arp4UI in vmp_rawnet{version}.Arp4UI(see c++ doc)
/*!
    Wrapper Cell->ui() for rawnet arp4ui(cell)<BR>
    @return user interface rawnet ui for cell.(The cell must be built with the Arp4UI user interface)
*/
/*!
    Arp4UI class in rawnet{version}/rawnet/arpui.h(pkg):<BR>Constructor Arp4UI(manager,helper,ifname)<BR>
    Arp4UI member function list:<BR>set_event(),arp4evt(),start(),stop(),inject(),add_sniffer(),
                                    start_sniffer(),ifname(),ifname_ip(),ifname_mac(),ipsrc(),macsrc(),
                                    targets()
*/
void rawnet_arpui(pylib::Module module);

#endif

