/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/03/2024
 */
 
#include "openssl_.h"

void openssl_ssl(pylib::Module module)
{
    pylib::Class<openssl::pkg::Ssl> ssl=module.class_<openssl::pkg::Ssl>("Ssl");
    ssl.def_("reset",&openssl::pkg::Ssl::reset);
    ssl.def_("set",&openssl::pkg::Ssl::set);
    ssl.def_("get_socket",&openssl::pkg::Ssl::get_socket);
    ssl.def_("get_errno",&openssl::pkg::Ssl::get_errno);
    ssl.def_("ctx",&openssl::pkg::Ssl::ctx,false);
    ssl.def_("get_local_x509",&openssl::pkg::Ssl::get_local_x509);
    ssl.def_("get_peer_x509",&openssl::pkg::Ssl::get_peer_x509);
    ssl.def_("send",&openssl::pkg::Ssl::send);
    ssl.def_("recv",&openssl::pkg::Ssl::recv);
    ssl.def_("key_update",&openssl::pkg::Ssl::key_update);
    ssl.def_("connect",&openssl::pkg::Ssl::connect);
    ssl.def_("accept",&openssl::pkg::Ssl::accept);
    ssl.def_("close",&openssl::pkg::Ssl::close);
}

