/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 21/03/2024
 */
 
#include "pylib.h"
#include "openssl4/openssl4.h"

#ifndef VAMPIRIA_PY_OPENSSL_H

#define VAMPIRIA_PY_OPENSSL_H 1

//!Python wrapper of the c++ namespace vampiria::openssl::pkg in vmp_openssl{version}.(see c++ doc)
/*!
    Function c++ openssl{version}/openssl{vernew_listension}.h(pkg):<BR>init(),end()
*/
/*!
    Wrapper Cell->ui() for ssl in sslui(cell)<BR>
    @return user interface ssl ui for cell.(The cell must be built with the SslUI user interface)
*/
/*!
    SslUI class in openssl{version}/openssl.h(pkg):<BR>Constructor SslUI(manager,ctimeout=default)<BR>
    SslUI member function list:<BR>set_event_client(),set_event_server(),new_client(),new_listen(),send(),
                                   key_update(),localaddr(),peeraddr(),proxyinfo(),connection_type(),
                                   connection_strtype(),get_local_x509(),get_peer_x509()
                                   
*/
/*!
    JrpUI class in openssl{version}/openssl.h(pkg):<BR>Constructor JrpUI(manager,ctx,logger=None)<BR>
    JrpUI member function list:<BR>set_timers(),set_limits(),set_connect_event(),set_request_event(),
                                   new_client(),new_listen(),key_update(),localaddr(),peeraddr(),
                                   proxyinfo(),session_localpeer(),connection_type(),connection_strtype(),
                                   ctx(),logger(),permits(),get_peer_x509(),peer_fingerprint(),peer_subject(),
                                   peer_permits(),peer_subject_f(),peer_permits_f(),add_reqdata(),add_reqstatus(),
                                   search_peer(),search_peer_p(),search_peer_o(),all_input(),all_input_f(),
                                   search_input_push(),search_input_push_f(),search_input_response(),
                                   search_input_response_f(),search_push(),search_push_f(),search_response(),search_response_f(),
                                   request(),request_f()
*/
void openssl_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::openssl::pkg in vmp_openssl{version}.(see c++ doc)
/*!
    Function c++ openssl{version}/openssl/hash.h(pkg):<BR>md5(),sha1(),sha224(),sha256(),sha384(),sha512()
*/
void openssl_hash(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::PKey in vmp_openssl{version}.PKey(see c++ doc)
/*!
    PKey class in openssl{version}/pkey.h(pkg):<BR>Constructor PKey()<BR>
    PKey member function list:<BR>reset(),keytype(),key_print(),type_str()
*/
void openssl_pkey(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::X509_Wrap in vmp_openssl{version}.X509_Wrap(see c++ doc)
/*!
    X509_Wrap class in openssl{version}/openssl/x509.h(pkg):<BR>Constructor X509_Wrap()<BR>
    X509_Wrap member function list:<BR>reset(),set_from_file(),parent(),version(),serial(),signature_info(),issuer(),validity_before(),
                                       validity_after(),subject(),pubkey(),id_issuer(),id_subject(),extensions(),
                                       signature_data(),fingerprint_sha1(),fingerprint_sha256(),verify()
*/
void openssl_x509(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::Ssl in vmp_openssl{version}.Ssl(see c++ doc)
/*!
    Ssl class in openssl{version}/openssl/ssl.h(pkg):<BR>Constructor Ssl()<BR>
    Ssl member function list:<BR>reset(),set(),get_socket(),get_errno(),ctx(),
                                 get_local_x509(),get_peer_x509(),send(),recv(),
                                 key_update(),connect(),accept(),close()
*/
    
void openssl_ssl(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::{Context class} in vmp_openssl{version}.{Context Class}(see c++ doc)
/*!
    Context class in openssl{version}/openssl{version}/ctx.h(pkg):<BR>No Constructor<BR>
    Ctx function list:get_x509()
    
*/
/*!
    Ctx_Base_Tls_Client class in openssl{version}/openssl/ctx/base.h(pkg):<BR>Constructor Ctx_Base_Tls_Client()<BR>
    Ctx_Base_Tls_Client function list:get()
*/
/*!
    Ctx_Base_Tls_Server class in openssl{version}/openssl/ctx/base.h(pkg):<BR>Constructor Ctx_Base_Tls_Server(pkey,x509)<BR>
    Ctx_Base_Tls_Server function list:get()
*/
/*!
    Ctx_Https_Tls class in openssl{version}/openssl/ctx/https.h(pkg):<BR>Constructor Ctx_Https_Tls(dircert,subject,days=default)<BR>
    Ctx_Https_Tls function list:get()
*/

/*!
    Ctx_Peer_Acl class in openssl{version}/openssl/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer_Acl()<BR>
    Ctx_Peer_Acl function list:fingerprint(),subject(),permits()
*/
/*!
    Ctx_Peer class in openssl{version}/openssl/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer(dircert,defp,subject,days=365000)<BR>
    Ctx_Peer function list:get(),get_x509(),subject(),fingerprint(),defp(),add_acl_peer(),del_acl_peer(),fingerprints_acl_peer(),
                                     gpeer_fingerprintet_acl_subject(),verify_acl_peer(),verify_peer(),print_acl()
*/
void openssl_ctx(pylib::Module module);

#endif


