/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/03/2024
 */
 
#include "openssl_.h"

struct Ctx_Base_Tls_Server_stub_Constructor:public pylib::Constructor<openssl::pkg::Ctx_Base_Tls_Server>
{
    openssl::pkg::Ctx_Base_Tls_Server *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            return new openssl::pkg::Ctx_Base_Tls_Server(dircert);
        }
        return 0;
    }
};

struct Ctx_Https_Tls_stub_Constructor:public pylib::Constructor<openssl::pkg::Ctx_Https_Tls>
{
    openssl::pkg::Ctx_Https_Tls *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp::str subject=args.get<vmp::str>(1);
            return new openssl::pkg::Ctx_Https_Tls(dircert,subject);
        }
        else if(args.size() == 3)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp::str subject=args.get<vmp::str>(1);
            vmp_uint days=args.get<vmp_uint>(2);
            return new openssl::pkg::Ctx_Https_Tls(dircert,subject,days);
        }
        return 0;
    }
};

struct Ctx_Peer_stub_Constructor:public pylib::Constructor<openssl::pkg::Ctx_Peer>
{
    openssl::pkg::Ctx_Peer *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp_uint defp=args.get<vmp_uint>(1);
            vmp::str subject=args.get<vmp::str>(2);
            return new openssl::pkg::Ctx_Peer(dircert,defp,subject);
        }
        else if(args.size() == 4)
        {
            vmp::str dircert=args.get<vmp::str>(0);
            vmp_uint defp=args.get<vmp_uint>(1);
            vmp::str subject=args.get<vmp::str>(2);
            vmp_uint days=args.get<vmp_uint>(3);
            return new openssl::pkg::Ctx_Peer(dircert,defp,subject,days);
        }
        return 0;
    }
};

struct stub_Ctx_Peer_verify_acl_peer:public pylib::Member_def<openssl::pkg::Ctx_Peer>
{
    pylib::Objref *def(openssl::pkg::Ctx_Peer *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
            return pylib::Converter<vmp_uint>(instance->verify_acl_peer(args.get<vmp::str>(0)));
        else if(args.size() == 2)
            return pylib::Converter<vmp_uint>(instance->verify_acl_peer(args.get<vmp::str>(0),args.get<vmp::str>(1)));
        return 0;
    }
};

void openssl_ctx(pylib::Module module)
{
    pylib::Class<openssl::pkg::Ctx> ctx=module.class_no_constructor<openssl::pkg::Ctx>("Ctx");
    ctx.def_("get_x509",&openssl::pkg::Ctx::get_x509); 
    
    pylib::Class<openssl::pkg::Ctx_Base_Tls_Client> btls_client=module.class_<openssl::pkg::Ctx_Base_Tls_Client>("Ctx_Base_Tls_Client");
    btls_client.def_("get",&openssl::pkg::Ctx_Base_Tls_Client::get,false);
    
    pylib::Class<openssl::pkg::Ctx_Base_Tls_Server> btls_server=module.class_with_constructor<openssl::pkg::Ctx_Base_Tls_Server>("Ctx_Base_Tls_Server",Ctx_Base_Tls_Server_stub_Constructor());
    btls_server.def_("get",&openssl::pkg::Ctx_Base_Tls_Server::get,false);
    
    pylib::Class<openssl::pkg::Ctx_Https_Tls> https_tls=module.class_with_constructor<openssl::pkg::Ctx_Https_Tls>("Ctx_Https_Tls",Ctx_Https_Tls_stub_Constructor());
    https_tls.def_("get",&openssl::pkg::Ctx_Https_Tls::get,false);
    
    pylib::Class<openssl::pkg::Ctx_Peer_Acl> pacl=module.class_<openssl::pkg::Ctx_Peer_Acl>("Ctx_Peer_Acl");
    pacl.def_("fingerprint",&openssl::pkg::Ctx_Peer_Acl::fingerprint);
    pacl.def_("subject",&openssl::pkg::Ctx_Peer_Acl::subject);
    pacl.def_("permits",&openssl::pkg::Ctx_Peer_Acl::permits);
    
    pylib::Class<openssl::pkg::Ctx_Peer> peer=module.class_with_constructor<openssl::pkg::Ctx_Peer>("Ctx_Peer",Ctx_Peer_stub_Constructor());
    peer.def_("get",&openssl::pkg::Ctx_Peer::get,false);
    peer.def_("get_x509",&openssl::pkg::Ctx_Peer::get_x509);
    peer.def_("subject",&openssl::pkg::Ctx_Peer::subject);
    peer.def_("fingerprint",&openssl::pkg::Ctx_Peer::fingerprint);
    peer.def_("defp",&openssl::pkg::Ctx_Peer::defp);
    peer.def_("add_acl_peer",&openssl::pkg::Ctx_Peer::add_acl_peer);
    peer.def_("reset_acl",&openssl::pkg::Ctx_Peer::reset_acl);
    peer.def_("del_acl_peer",&openssl::pkg::Ctx_Peer::del_acl_peer);
    peer.def_("fingerprints_acl_peer",&openssl::pkg::Ctx_Peer::fingerprints_acl_peer);
    peer.def_("get_acl_subject",&openssl::pkg::Ctx_Peer::get_acl_subject);
    peer.def_with_stub("verify_acl_peer",stub_Ctx_Peer_verify_acl_peer());
    peer.def_("verify_peer",&openssl::pkg::Ctx_Peer::verify_peer);
    peer.def_("print_acl",&openssl::pkg::Ctx_Peer::print_acl);
}

