#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date : 05/04/2024

import vmp
import vmp_event  as event
import vmp_plugin as plugin

def exit_(i):
  data=vmp.instance_.get_global()
  data.manager.stop()
  
def client_f(par,var):
  data=vmp.instance_.get_global()
  data.modname=par[0]
  data.plugname=par[1]
  data.rootpath=vmp.env.format_path(par[2])
  data.subject=par[3]
  if par[4] == 'yes':
    data.prompt=True
  else:
    data.prompt=False
  if(len(var) == 5) or par[5] == 'no':
    data.debug=False
  else:
    data.debug=True
  vmp.debug("modname {0}".format(data.modname))
  vmp.debug("plugname {0}".format(data.plugname))
  vmp.debug("rootpath {0}".format(data.rootpath))
  vmp.debug("subject {0}".format(data.subject))
  vmp.debug("prompt {0}".format(data.prompt))
  vmp.debug("debug {0}".format(data.debug))
  data.plugin=plugin.plugin_import(data.modname,data.plugname,"openssl.clientjrp",[data.manager,data.rootpath,data.subject,data.prompt,data.debug],var)

def inputcmd(cell,istr):
  data=vmp.instance_.get_global()
  data.plugin.command(istr)
   
def vmp_main():
  data=vmp.instance_.get_global()
  data.manager=event.Manager()
  vmp.signal_wrap(['sigint','sigterm'],exit_)
  data.inputui=event.InputUI(data.manager)
  data.inputui.set_event(inputcmd,None)
  try:
    vmp.input_f('client',client_f)
    data.inputui.input()
    data.plugin.prompt()
    data.manager.loop()
  except Exception as e:
    vmp.error(str(e))
    exit_(0)
  vmp.exit_ok()


    
  

