#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date : 12/03/2024

import vmp
import vmp_openssl4 as openssl
import vmp_json     as json

PluginName="JrpForensics"

def status(plugin,args):
  ret=[]
  try:
    if len(args) == 1:
      sid=args[0]
    else:
      sid=""
    j=json.Json()
    json.japi_status(j.root(),sid)
    ret.append(plugin.send_request(j.root()))
  except Exception as e:
    vmp.error(str(e))
  return ret

class Plugin(openssl.ClientJrp):
  def __init__(self,data,options):
    openssl.ClientJrp.__init__(self,data,options)
    self.add_command("status","Send a jrp status request",0,[("id status",'generic')],status)

  def response(self,jreq,jdata):
    jd=json.JData()
    jd.set(jdata)
    if jd.jtype() == json.japi("statusupdate"):
      sid=jd.get_text("id")
      if sid == '':
        sid='@empty' 
      if not sid in self.vars:
        self.setvar(sid,{},'status id {0} var'.format(sid))
      key=jd.get_text("key")
      jobj=json.JsonObj()
      j=json.Json()
      jd.get_subtype("data",jobj)
      j.json_new_obj(jobj)
      self.vars[sid].value[key]=j.json_str()
    elif jd.jtype() == json.japi("statuscancel"):
      sid=jd.get_text("id")
      if sid == '':
        sid='@empty' 
      key=jd.get_text("key")
      if (sid in self.vars) and (key in self.vars[rid]):
        self.vars[sid].pop(key)
      
class PluginTopic(openssl.ClientJrpTopic):
  def __init__(self,modname,plugname):
    openssl.ClientJrpTopic.__init__(self,modname,plugname)
    self.set_function("response","Reads update data and inserts them into local variables",[('jreq','json request associated'),('jdata','json object data recv')])
    

