/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 16/02/2024
 */

#ifndef VAMPIRIA_OPENSSL_PKG_PKEY_H

#define VAMPIRIA_OPENSSL_PKG_PKEY_H 1

namespace vampiria { namespace openssl { namespace pkg {

//!Container used for openssl keys
class PKey
{
    private:
        //!Internal usage
        void pointer_except();

        vmp::str keytype_;
    public:
        //! A constructor
        PKey();

        //! A destructor
        ~PKey();

        EVP_PKEY *pkey_;/*!<openssl key*/
         
        //! Allocates an empty structure(free ssl memory when destroy object)
        /*!
            @sa pkey_
        */
        void set_empty();
        
        //! Set key
        /*!
            @param pkey openssl key
            @param pubkey if true the key is private otherwise is puclic key(default public key) 
            @sa pkey_
            @sa keytype_
            @returrn void or except in case of failure
        */
        void set(EVP_PKEY *pkey,vmp_bool privkey=false);
        
        //! Copy the value from the input pkey
        /*!
            @param pkey input key
            @return void or except in case of failure
        */
        void copy(openssl::pkg::PKey *pkey);
        
        //!Reset container
        void reset();

        //! Returns the stored key type
        /*!
            @sa keytype_
            @return "public","private" or "" in case empty key
        */
        vmp::str keytype();
        
        //!Print the key in human readable form
        /*!
            @return key in string format or except in case of failure
        */
        vmp::str key_print();
};

}}}

#endif

