/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/02/2024
 */

#ifndef VAMPIRIA_OPENSSL_PKG_HASH_H

#define VAMPIRIA_OPENSSL_PKG_HASH_H 1

namespace vampiria { namespace openssl { namespace pkg {

//! Calculates the md5 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value or except in case of failure
*/
vmp::str md5(vmp::str istr,vmp::str delimiter="");

//! Calculates the sha1 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value or except in case of failure
*/
vmp::str sha1(vmp::str istr,vmp::str delimiter="");

//! Calculates the sha224 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value
*/
vmp::str sha224(vmp::str istr,vmp::str delimiter="");

//! Calculates the sha256 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value or except in case of failure
*/
vmp::str sha256(vmp::str istr,vmp::str delimiter="");

//! Calculates the sha384 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value or except in case of failure
*/
vmp::str sha384(vmp::str istr,vmp::str delimiter="");

//! Calculates the sha512 cryptographic hash function of the input string
/*!
    @param istr input string
    @param delimiter byte delimiter
    @return hash value or except in case of failure
*/
vmp::str sha512(vmp::str istr,vmp::str delimiter="");

}}}

#endif

