/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 11/02/2024
 */
 
#ifndef VAMPIRIA_OPENSSL_PKG_EVENTSSL_H

#define VAMPIRIA_OPENSSL_PKG_EVENTSSL_H 1

namespace vampiria { namespace openssl { namespace pkg {

const vmp_int CONN_NONE=0;/*!<Connection Type not connected*/
const vmp_int CONN_SSLLISTEN=1;/*!<Connection Type ssl listen*/
const vmp_int CONN_SSLSERVER=2;/*!<Connection Type ssl server*/
const vmp_int CONN_SSLCLIENT=3;/*!<Connection Type ssl client*/
const vmp_int CONN_SSLPROXY=4;/*!<Connection Type ssl client via proxy mode*/

//!Ssl class event(see framework event)
class EventSsl:public net::EventConnection
{
    private:
       //! Reset Ssl event
       void evt_ssl_reset(vmp_bool init=false);
    public:
       //! A Constructor
       EventSsl();

       //! A Destructor
       ~EventSsl();
       
        event::EVTCB tcpconnect_;/*!<Called when a connection tcp connect is complete*/
        net::EVTCBACCEPT tcpaccept_;/*!<Tcp server accept callback.Called when a connection tcp is accepted*/
        event::EVTCB sslconnect_;/*!<Called when connect handshake is complete*/
        openssl::pkg::Ctx ctx_;/*!<Ssl context associated*/
        openssl::pkg::Ssl ssl_;/*!<Ssl connection associated*/
        vmp::time::Time ctimeout_;/*!<Connection timeout*/
       
        //!Create a new event ssl client
        /*!
            @param ui user interface (see Class UI)
            @param peer remote server address
            @param ctx ssl context
            @param tcpconnect function performed when tcp connect is complete
            @param sslconnect function performed when connect handshake is complete
            @param recv function performed when data is received
            @param close function performed at the end of the event
            @param ctimeout connection timeout
            @param proxy contains the information of proxy connections(0 no proxy connection)
            @return the new cell associated with the event or except in case of failure
        */
        event::Cell *evt_ssl_client(event::UI *ui,net::Address *peer,openssl::pkg::Ctx *ctx,event::EVTCB tcpconnect,event::EVTCB sslconnect,event::EVTCBBUF recv,event::EVTCB close,vmp::time::Time ctimeout,net::ProxyInfo *proxy=0);
       
        //!Create a new event ssl server
        /*!
            @param ui user interface (see Class UI)
            @param local address to listen server connection
            @param backlog the maximum length to which the  queue  of pending  connections
            @param ctx ssl context
            @param tcpaccept function performed when connection tcp is accepted
            @param svlcevent function performed when close listen socket
            @param sslconnect function performed when connect handshake is complete
            @param recv function performed when data is received
            @param svcevent function performed when close server connection
            @param ctimeout connection timeout
            @return the new cell associated with the event or except in case of failure
        */
        event::Cell *evt_ssl_listen(event::UI *ui,net::Address *local,vmp_uint backlog,openssl::pkg::Ctx *ctx,net::EVTCBACCEPT tcpaccept,event::EVTCB svlcevent,event::EVTCB sslconnect,event::EVTCBBUF recv,event::EVTCB svcevent,vmp::time::Time ctimeout);
        
        //! Renegotiate the session key with the peer
	/*!
	    @param cell event cell
	    @return void or except in case of failure
	*/
	void evt_ssl_key_update();
	
        //! Returns ssl connection type
        /*!
            @return connection type
        */
        vmp_int evt_ssl_type();
        
        //! Returns connection type in string format
        /*!
            @return connection type in string format
        */
        vmp::str evt_ssl_strtype();
        
        //!Gets the local's certificate
        /*!
            @param cell cell associated
            @param cout certificate output
            @return void or except in case of failure
        */
        void evt_ssl_local_x509(openssl::pkg::X509_Wrap *cout);
        
        //!Gets the local's certificate
        /*!
            @param cell cell associated
            @param cout certificate output
            @return void or except in case of failure
        */
        void evt_ssl_peer_x509(openssl::pkg::X509_Wrap *cout);
        
        //! Close event
        void evt_ssl_close();
       
        //! Free event
        void evt_ssl_free();
};

}}}

#endif

