/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 19/02/2024
 */

#include "openssl4/openssl4.h"

namespace vampiria { namespace openssl { namespace pkg {

EventSsl::EventSsl():net::EventConnection()
{
    evt_ssl_reset(true);    
}
       
EventSsl::~EventSsl()
{
    evt_ssl_reset();
}

void EventSsl::evt_ssl_reset(vmp_bool init)
{
    tcpconnect_=event::empty_ev;
    tcpaccept_=net::empty_accept_ev;
    sslconnect_=event::empty_ev;   
    ctimeout_=0.0;
    if(!init)
    {
        ctx_.reset();
        ssl_.reset();
    }
}

event::Cell *EventSsl::evt_ssl_client(event::UI *ui,net::Address *peer,openssl::pkg::Ctx *ctx,event::EVTCB tcpconnect,event::EVTCB sslconnect,event::EVTCBBUF recv,event::EVTCB close,vmp::time::Time ctimeout,net::ProxyInfo *proxy)
{
    vmp::except_check_pointer((void *)ctx,"openssl::pkg::EventSsl::evt_ssl_client(ctx=null)");
    vmp::except_check_pointer((void *)ctx->ctx_,"openssl::pkg::EventSsl::evt_ssl_client(ctx.ctx_=null)");
    ctx_.copy(ctx);
    if(tcpconnect != 0)
        tcpconnect_=tcpconnect;
    if(sslconnect != 0)
        sslconnect_=sslconnect;
    ctimeout_=ctimeout;
    return evt_connection_tcpclient(ui,peer,ssl_tcp_connect,recv,close,proxy);
}

event::Cell *EventSsl::evt_ssl_listen(event::UI *ui,net::Address *local,vmp_uint backlog,openssl::pkg::Ctx *ctx,net::EVTCBACCEPT tcpaccept,event::EVTCB svlcevent,event::EVTCB sslconnect,event::EVTCBBUF recv,event::EVTCB svcevent,vmp::time::Time ctimeout)
{
    vmp::except_check_pointer((void *)ctx,"openssl::pkg::EventSsl::evt_ssl_listen(ctx=null)");
    vmp::except_check_pointer((void *)ctx->ctx_,"openssl::pkg::EventSsl::evt_ssl_listen(ctx.ctx_=null)");
    ctx_.copy(ctx);
    if(tcpaccept != 0)
        tcpaccept_=tcpaccept;
    if(sslconnect != 0)
        sslconnect_=sslconnect;
    ctimeout_=ctimeout;
    return evt_connection_tcplisten(ui,local,backlog,openssl::pkg::ssl_tcp_accept,svlcevent,recv,svcevent);
}

void EventSsl::evt_ssl_key_update()
{
    if(ssl_.key_update() == -1)
        vmp::except_s("openssl::pkg::EventSsl::evt_ssl_key_update() failed");
}

vmp_int EventSsl::evt_ssl_type()
{
    vmp_int ctype=evt_connection_type();
    switch(ctype)
    {
        case net::CONN_TCPLISTEN:
            return openssl::pkg::CONN_SSLLISTEN;
        case net::CONN_TCPSERVER:
            return openssl::pkg::CONN_SSLSERVER;
        case net::CONN_TCPCLIENT:
            return openssl::pkg::CONN_SSLCLIENT;
        case net::CONN_TCPPROXY:
            return openssl::pkg::CONN_SSLPROXY;
        default: 
            break;
    }
    return openssl::pkg::CONN_NONE;
}

vmp::str EventSsl::evt_ssl_strtype()
{
    switch(evt_ssl_type())
    {
        case openssl::pkg::CONN_NONE:
            return "NONE";
        case openssl::pkg::CONN_SSLLISTEN:
            return "SSLLISTEN";
        case openssl::pkg::CONN_SSLSERVER:
            return "SSLSERVER";
        case openssl::pkg::CONN_SSLCLIENT:
            return "SSLCLIENT";
        case openssl::pkg::CONN_SSLPROXY:
            return "SSLPROXY";
        default:
            vmp::except("net::EventConnection::evt_connection_strtype() conntype_=%d bad value",conntype_);
    }
    return "";
}

void EventSsl::evt_ssl_local_x509(openssl::pkg::X509_Wrap *cout)
{
    return ctx_.get_x509(cout); 
}

void EventSsl::evt_ssl_peer_x509(openssl::pkg::X509_Wrap *cout)
{
    return ssl_.get_peer_x509(cout);
}

void EventSsl::evt_ssl_close()
{
    try
    {
        ssl_.close();
    }
    catch(vmp::exception &x)
    {
    }
    evt_connection_close();
}
       
void EventSsl::evt_ssl_free()
{
    evt_ssl_reset();
    evt_connection_free();
}

}}}

