/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 09/04/2024
 */

#include "openssl4/openssl4.h"

namespace vampiria { namespace openssl { namespace pkg {

JrpCommon::JrpCommon(event::Manager *manager,openssl::pkg::Ctx_Peer *ctx):JrpCommon_I()
{
    p2pcommon_=new openssl::pkg::P2pCommon(manager,ctx);
    p2pcommon_->set_timer(0.0,60,openssl::pkg::jrp_pingcb);
    jrp_connect_callback(0,0,0,0,0,0,0);
    stimeout_=5.0;
}

JrpCommon::~JrpCommon()
{
    delete p2pcommon_;
}

void JrpCommon::set_stimeout(vmp::time::Time stimeout)
{
    if(stimeout > 0)
        stimeout_=stimeout;
}

void JrpCommon::set_limits(vmp_size maxssrvpeer,vmp_size maxclientreq)
{
    if(maxssrvpeer > 0)
        maxssrvpeer_=maxssrvpeer;
    if(maxclientreq > 0)
        maxclientreq_=maxclientreq;
}

void JrpCommon::jrp_connect_callback(event::EVTCB tcpconnect,net::EVTCBACCEPT tcpaccept,event::EVTCB jrpcsession,event::EVTCB jrpssession,event::EVTCB jrpcclose,event::EVTCB jrplclose,event::EVTCB jrpsclose)
{
    if(tcpaccept == 0)
        tcpaccept_=net::empty_accept_ev;
    else
        tcpaccept_=tcpaccept;
    if(jrpcsession == 0)
        jrpcsession_=event::empty_ev;
    else
        jrpcsession_=jrpcsession;
    if(jrpssession == 0)
        jrpssession_=event::empty_ev;
    else
        jrpssession_=jrpssession;
    if(jrpcclose == 0)
        jrpcclose_=event::empty_ev;
    else
        jrpcclose_=jrpcclose;
    if(jrplclose == 0)
        jrplclose_=event::empty_ev;
    else
        jrplclose_=jrplclose;
    if(jrpsclose == 0)
        jrpsclose_=event::empty_ev;
    else
        jrpsclose_=jrpsclose;
    p2pcommon_->p2p_callback(tcpconnect,openssl::pkg::jrp_tcpacceptcb,openssl::pkg::jrp_sessioncb,openssl::pkg::jrp_initcb,openssl::pkg::jrp_closecb,openssl::pkg::jrp_closecb);
}

vmp::str JrpCommon::key_impl(json::jrp::JrpReq *jreq)
{
    vmp::str ret;
    openssl::pkg::EventJrp *jrp=jreq->cell()->event<openssl::pkg::EventJrp>();
    vmp::unicode::str_write(&ret,"jrp/%s/%u",jrp->peer_.fingerprint().c_str(),jreq->rid());
    return ret;
}

void JrpCommon::send_impl(json::jrp::JrpReq *jreq,vmp::Buf *buf)
{
    openssl::pkg::EventJrp *jrp=jreq->cell()->event<openssl::pkg::EventJrp>();
    jrp->evt_connection_send(buf);
}

EventJrp::EventJrp():EventP2p()
{
    evt_jrp_reset();
}

EventJrp::~EventJrp()
{
}

void EventJrp::evt_jrp_reset()
{
    jrpcommon_=0;
    refrid_=0;
    timerecv_=0;
    timeping_=0;
    timetmp_=0;
    reqdata_.reset();
}

event::Cell *EventJrp::evt_jrp_client(event::UI*ui,net::Address*peer,openssl::pkg::JrpCommon *common,net::ProxyInfo *proxy)
{
    vmp::except_check_pointer((void *)common,"openssl::pkg::EventJrp::evt_jrp_client(common=null)");
    jrpcommon_=common;
    return evt_p2p_client(ui,peer,jrpcommon_->p2pcommon_,proxy);
}

event::Cell *EventJrp::evt_jrp_server(event::UI *ui,net::Address *local,openssl::pkg::JrpCommon *common)
{
    vmp::except_check_pointer((void *)common,"openssl::pkg::EventJrp::evt_jrp_server(common=null)");
    jrpcommon_=common;
    return evt_p2p_server(ui,local,jrpcommon_->p2pcommon_);
}

json::jrp::JrpReq *EventJrp::evt_jrp_request(json::JsonObj *jdata)
{
    json::jrp::JrpReq *ret;
    vmp_index count=0; 
    while(cltreq_.search(refrid_,&ret))
    {
        count++;
        refrid_++;
        if(count == jrpcommon_->maxclientreq_)
            vmp::except_s("Overflow request");
        if(refrid_ == jrpcommon_->maxclientreq_)
            refrid_=0;
    }
    ret=jrpcommon_->new_request(refrid_,jdata,cell_);
    cltreq_.insert(refrid_,ret);
    refrid_++;
    return ret;
}

void EventJrp::evt_jrp_close()
{
    vmp::Buf buf;
    if(evt_connection_type() != net::CONN_TCPLISTEN)
    {
        if(cell_ ->closelevel_ == "openssl::EventP2p")
        {
            if(cell_->errcode_ == openssl::pkg::p2p_accessdenied)
            {
                cell_->errcode_=json::jrp::status_accessdenied;
                cell_->err_=json::jrp::msg_status(cell_->errcode_);
                json::jrp::abort(&buf,cell_->errcode_,cell_->err_);
            }
            else if(cell_->errcode_ == openssl::pkg::p2p_duplexsession)  
            {
                cell_->errcode_=json::jrp::status_duplexsession;
                cell_->err_=json::jrp::msg_status(cell_->errcode_);
                json::jrp::abort(&buf,cell_->errcode_,cell_->err_);
            }
            else
                json::jrp::abort(&buf,json::jrp::status_err,cell_->err_);
            cell_ ->closelevel_="openssl::EventJrp";
            evt_connection_send(&buf,true);
        }
        else if(!((cell_ ->closelevel_ == "net::net::EventConnection") ||
                (cell_ ->closelevel_ == "openssl::EventSsl") ||
                (cell_ ->closelevel_ == "openssl::EventJrp") || 
                (cell_ ->closelevel_ == "openssl::EventJrpPeer")))
        {
             json::jrp::abort(&buf,json::jrp::status_ok);
             evt_connection_send(&buf,true);
        }
        vmp::vector<json::jrp::JrpReq *> csrvs=srvreq_.all_data(); 
        for(vmp_index i=0;i<csrvs.size();i++)
            csrvs[i]->recv_close(json::jrp::status_closeconnection);
        vmp::vector<json::jrp::JrpReq *> creqs=cltreq_.all_data();
        for(vmp_index i=0;i<creqs.size();i++)
            creqs[i]->recv_close(json::jrp::status_closeconnection);
    }
    evt_p2p_close();
}

void EventJrp::evt_jrp_free()
{
    evt_jrp_reset();
    evt_p2p_free();
}

}}}

