/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 03/04/2024
 */

#include "openssl4/openssl4.h"

namespace vampiria { namespace openssl { namespace pkg {

void p2p_timer(event::Cell *cell)
{
    openssl::pkg::P2pTimerRef *tevent=cell->event<openssl::pkg::P2pTimerRef>();
    openssl::pkg::P2pCommon *common=cell->ui<openssl::pkg::P2pCommon>();
    common->p2ptimercb_(tevent->master_);
}

void p2p_tcp_connect(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    openssl::pkg::EventP2p *p2p=cell->event<openssl::pkg::EventP2p>();
    cell->read_=openssl::pkg::p2p_ssl_recv;
    p2p->send_=openssl::pkg::p2p_send;
    manager->unlock();
    p2p->common_->tcpconnect_(cell);
}

void p2p_tcp_accept(event::Cell *cell,event::Cell *child)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    openssl::pkg::EventP2p *parent=cell->event<openssl::pkg::EventP2p>();
    openssl::pkg::EventP2p *p2p=child->event<openssl::pkg::EventP2p>();
    p2p->common_=parent->common_;
    try
    {
        p2p->evt_p2p_new_timer();
        child->read_=openssl::pkg::p2p_ssl_recv;
        p2p->send_=openssl::pkg::p2p_send;
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"openssl::EventP2p",openssl::pkg::p2p_err,x.what());
    }
    manager->unlock();
    p2p->common_->tcpaccept_(cell,child);
}

void p2p_session(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    openssl::pkg::EventP2p *p2p=cell->event<openssl::pkg::EventP2p>();
    if(p2p->common_->ctx_->verify_peer(&(p2p->ssl_),&(p2p->peer_)) == 0)
    {    
        manager->cell_close_err_spec(cell,"openssl::EventP2p",openssl::pkg::p2p_accessdenied,
                                     openssl::pkg::p2p_msg_status(openssl::pkg::p2p_accessdenied));
        manager->unlock();
        return;
    }
    try
    {
        p2p->common_->p2ptable_.insert(p2p->peer_.fingerprint(),cell);
        manager->cell_alloc(cell);
        p2p->isopensession_=true;
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"openssl::EventP2p",openssl::pkg::p2p_duplexsession,
                                     openssl::pkg::p2p_msg_status(openssl::pkg::p2p_duplexsession));
        manager->unlock();
        return;                             
    }
    manager->unlock();
    p2p->common_->p2psession_(cell);
}

void p2p_ssl_recv(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    vmp::Buf buf,tmp;
    manager->lock();
    openssl::pkg::EventP2p *p2p=cell->event<openssl::pkg::EventP2p>();
    try
    {
        vmp_int ret=p2p->ssl_.recv(&buf);
        if(ret == 0)
            manager->cell_close_ok_spec(cell,"openssl::EventP2p");
        else if(ret > 0)
        {
            exec=manager->cell_update(cell);
            while(buf.size_reading() != 0)
            { 
                vmp_size s=buf.read_size(4);
                buf.read_buf(&tmp,s);
                if(exec)
                {
                    try
                    {
                         manager->unlock();
                         p2p->recv_(cell,&tmp);
                         manager->lock();
                    }
                    catch(vmp::exception &x)
                    {
                    }
                }
            }
            buf.reset();
        }
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"openssl::EventP2p",p2p->ssl_.get_errno(),openssl::pkg::err_string());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"openssl::EventP2p",0,x.what());
    }
    manager->unlock();
}

void p2p_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
   vmp::Buf send;
   send.write_size(buf->size(),4);
   send.cat(buf);
   send.index();
   event::Manager *manager=cell->get_manager();
   openssl::pkg::EventP2p *p2p=cell->event<openssl::pkg::EventP2p>();
   if(p2p->ssl_.send(&send) == -1)
       manager->cell_close_err_spec(cell,"openssl::EventP2p",vmp::get_errno(),vmp::value_errno());
}

}}}

