/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 02/03/2024
 */
 
#ifndef VAMPIRIA_OPENSSL_PKG_CB_H

#define VAMPIRIA_OPENSSL_PKG_CB_H 1

namespace vampiria { namespace openssl { namespace pkg {

//! Internal usage(sslcb.cc)
void ssl_tcp_connect(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_tcp_accept(event::Cell *cell,event::Cell *child);

//! Internal usage(sslcb.cc)
void ssl_ssl_connect(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_accept(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_ssl_recv(event::Cell *cell);

//! Internal usage(sslcb.cc)
void ssl_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(p2pcb.cc)
void p2p_timer(event::Cell *cell);

//! Internal usage(sslcb.cc)
void p2p_tcp_connect(event::Cell *cell);

//! Internal usage(p2pcb.cc)
void p2p_tcp_accept(event::Cell *cell,event::Cell *child);

//! Internal usage(p2pcb.cc)
void p2p_session(event::Cell *cell);

//! Internal usage(p2pcb.cc)
void p2p_ssl_recv(event::Cell *cell);

//! Internal usage(p2pcb.cc)
void p2p_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(jrpcb.cc)
void jrp_pingcb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrp_tcpacceptcb(event::Cell *cell,event::Cell *child);

//! Internal usage(jrpcb.cc)
void jrp_sessioncb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrp_session_abort(event::Cell *cell,vmp_int ret,vmp::str msg="");

//! Internal usage(jrpcb.cc)
void jrp_initcb(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(jrpcb.cc)
void jrp_recvcb(event::Cell *cell,vmp::Buf *buf);

//! Internal usage(jrpcb.cc)
void jrp_closecb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_tcpconnectcb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_tcpacceptcb(event::Cell *cell,event::Cell *child);

//! Internal usage(jrpcb.cc)
void jrpui_csessioncb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_ssessioncb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_lclosecb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_cclosecb(event::Cell *cell);

//! Internal usage(jrpcb.cc)
void jrpui_sclosecb(event::Cell *cell);

}}}

#endif

