/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 03/04/2024
 */

#include "vmp.h"

namespace vampiria { namespace vmp { namespace utils {

Logger::Logger()
{
    reset();
}

Logger::~Logger()
{
    reset();
}

void Logger::reset()
{
    logname_="";    
    loglevel_=vmp::utils::LOG_NO;
}

void Logger::set(vmp::str filepath,vmp_byte facility,vmp_bool newfile)
{
    if(loglevel_ > vmp::utils::LOG_ERR)
        vmp::except_s("Invalid facility value");
    logname_=filepath;
    loglevel_=facility;
    if(loglevel_ != vmp::utils::LOG_NO)
        vmp::output_file_s(logname_,newfile,"");
}

void Logger::write_s(vmp_byte facility,vmp::str value)
{
    vmp::str type=""; 
    switch(facility)
    {        
        case vmp::utils::LOG_DEBUG: type=" [LEVEL DEBUG]:";break;                
        case vmp::utils::LOG_INFO : type=" [LEVEL INFO]:";break;
        case vmp::utils::LOG_WARN : type=" [LEVEL WARNING]:";break;  
        case vmp::utils::LOG_ERR  : type=" [LEVEL ERROR]:";break;
        default:vmp::except_s("Invalid facility value");break;
    }                
    if((loglevel_ <= facility) && (loglevel_ != vmp::utils::LOG_NO))
        vmp::output_file(logname_,false,"%s%s%s\n",vmp::time::ctime_wrap().c_str(),type.c_str(),value.c_str());       
}

void Logger::write(vmp_byte facility,const vmp_char *fmt,...)
{
    va_list ap;
    va_start(ap,fmt);    
    vmp::str sfmt=va_wrap(fmt,ap);
    va_end(ap);
    write_s(facility,sfmt);
}

void Logger::rotate(vmp_index n)
{
    vmp::str src,dst;
    if(loglevel_ != vmp::utils::LOG_NO)
    {
        for(vmp_index i=n-1;n>0;n--)
        {
            vmp::unicode::str_write(&src,"%s.%d",logname_,i);
            vmp::unicode::str_write(&dst,"%s.%d",logname_,i+1);
            if(vmp::fs::isfile(src))
                vmp::copy_file(src,dst);
        }
        vmp::unicode::str_write(&dst,"%s.1",logname_);
        if(vmp::fs::isfile(logname_))
            vmp::copy_file(logname_,dst);
         vmp::output_file_s(logname_,true,"");
    }
}

}}}

