/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 03/02/2020
 */

#ifndef VAMPIRIA_PYLIB_STUBCONSTRUCTOR_H

#define VAMPIRIA_PYLIB_STUBCONSTRUCTOR_H 1

namespace vampiria { namespace pylib {

template<class W>
struct Constructor_default:public pylib::Constructor<W>
{
    W *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 0)
             return new W();
         return 0;
    }
};

template<class W>
struct Constructor_no_allocated:public pylib::Constructor<W>
{
    W *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::except_s("class can not be built dynamically");
         return 0;
    }
};

}}

#endif

