/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 02/07/2023
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

extern "C" {

static pylib::Objref *def_descr_get(pylib::Objref *func,pylib::Objref *obj,pylib::Objref *type_)
{
    if(is_null(obj) || is_none(obj))
    {
        pylib::incref(func);
        return func;
    }
    return PyMethod_New(func,obj);
}

static void def_dealloc(pylib::Objref *self)
{
    delete static_cast<pylib::Def *>(self);
}

static pylib::Objref *def_call(pylib::Objref *self,pylib::Objref *args,pylib::Objref *kw)
{
    pylib::Def *def=static_cast<Def *>(self);
    return def->call(args,kw);
}

pylib::Objtype def_type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    const_cast<vmp_char*>("Vampiria.Pylib.Def"),
    sizeof(Def),
    0,
    (destructor)def_dealloc,            /* tp_dealloc */
    0,                                  /* tp_print */
    0,                                  /* tp_getattr */
    0,                                  /* tp_setattr */
    0,                                  /* tp_compare */
    0,                                  /* tp_repr */
    0,                                  /* tp_as_number */
    0,                                  /* tp_as_sequence */
    0,                                  /* tp_as_mapping */
    0,                                  /* tp_hash */
    def_call,                           /* tp_call */
    0,                                  /* tp_str */
    0,                                  /* tp_getattro */
    0,                                  /* tp_setattro */
    0,                                  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                 /* tp_flags */
    0,                                  /* tp_doc */
    0,                                  /* tp_traverse */
    0,                                  /* tp_clear */
    0,                                  /* tp_richcompare */
    0,                                  /* tp_weaklistoffset */
    0,                                  /* tp_iter */
    0,                                  /* tp_iternext */
    0,                                  /* tp_methods */
    0,                                  /* tp_members */
    0,                                  /* tp_getset */
    0,                                  /* tp_base */
    0,                                  /* tp_dict */
    def_descr_get,                      /* tp_descr_get */
    0,                                  /* tp_descr_set */
    0,                                  /* tp_dictoffset */
    0,                                  /* tp_init */
    0,                                  /* tp_alloc */
    0,                                  /* tp_new */
    0,                                  /* tp_free */
    0,                                  /* tp_is_gc */
    0,                                  /* tp_bases */
    0,                                  /* tp_mro */
    0,                                  /* tp_cache */
    0,                                  /* tp_subclasses */
    0,                                  /* tp_weaklist */
    0                                   /* tp_del */
};

}//extern C

Def::Def(pylib::py_function *pf,vmp::str name,pylib::Objbase &base)
{
    head_=pf;
    tail_=pf;
    if (Py_TYPE(&def_type) == 0)
    {
        Py_SET_TYPE(&def_type,&PyType_Type);
        ::PyType_Ready(&def_type);
    }
    PyObject_INIT(this,&def_type);
    pyobj_setattr<pylib::Objref *>(base.ref(),name,this);
    vmp::unicode::str_write(&fullname_,"%s.%s()",base.fullname().c_str(),name.c_str());
}
        
Def::~Def()
{
    pylib::py_function *iter=head_,*next;
    while (iter != 0)
    {
        next=iter->next_;
        delete iter;
        iter=next;
    }
}

void Def::insert_py(pylib::py_function *pf)
{
    tail_->next_=pf;
    tail_=pf;
}

pylib::Objref *Def::call(pylib::Objref *args,pylib::Objref *kw)
{
    pylib::py_function *iter=head_;
    vmp::str error,nargs="";
    while(iter != 0)
    {
        try
        {
            pylib::Objref *ret=(*iter)(args,kw);
            pyerr_occurred();
            if(ret != 0)
               return ret;
        }
        catch(const vmp::bad_alloc&)
        {
            PyErr_NoMemory();
            return 0;
        }
        catch(const vmp::invalid_argument& x)
        {
            vmp::str w(x.what()); 
            if((w != "") && ((nargs == "") || (nargs < w)))
                nargs=x.what();
        }
        catch(const vmp::runtime_error &x)
        {
            PyErr_SetString(PyExc_RuntimeError,x.what());
            return 0;
        }
        catch(const vmp::exception& x)
        {
            vmp::unicode::str_write(&error,"%s %s",fullname_.c_str(),x.what());
            PyErr_SetString(PyExc_RuntimeError,error.c_str());
            return 0;
        }
        catch(...)
        {
            PyErr_SetString(PyExc_RuntimeError, "Vampiria::pylib unidentifiable C++ exception");
            return 0;
        }
        iter=iter->next_;
    }
    if(nargs == "")
       vmp::unicode::str_write(&error,"%s Invalid number of arguments",fullname_.c_str());
    else
       vmp::unicode::str_write(&error,"%s Invalid argument %s",fullname_.c_str(),nargs.c_str());
    PyErr_SetString(PyExc_ValueError,error.c_str());
    return 0;
}

}}

