/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

template<>
vmp_char arg_from_python<vmp_char>(pylib::Objref *obj)
{
    try
    {
        return pylib::pychar_aschar(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_char>() %s",x.what());   
    }
    return 0x00;    
}

template<>
vmp_uchar arg_from_python<vmp_uchar>(pylib::Objref *obj)
{
    try
    {
        return pylib::pychar_asuchar(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_uchar>() %s",x.what());   
    }
    return 0x00;
}

template<>
vmp_int arg_from_python<vmp_int>(pylib::Objref *obj)
{
    try
    {
        return pylib::pylong_aslong(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_int>() %s",x.what());   
    }
    return -1; 
}

template<>
vmp_uint arg_from_python<vmp_uint>(pylib::Objref *obj)
{
    try
    {
        return pylib::pylong_asulong(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_uint>() %s",x.what());   
    }
    return 0;
}

template<>
vmp_int16 arg_from_python<vmp_int16>(pylib::Objref *obj)
{
    try
    {
        return pylib::pylong_asint16(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_int16>() %s",x.what()); 
    }
    return -1;    
}

template<>
vmp_uint16 arg_from_python<vmp_uint16>(pylib::Objref *obj)
{
    try
    {
        return pylib::pylong_asuint16(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_uint16>() %s",x.what()); 
    }
    return 0;
}

template<>
vmp_real arg_from_python<vmp_real>(pylib::Objref *obj)
{
    try
    {
        return pylib::pyfloat_asreal(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_real>() %s",x.what()); 
    }
    return 0.0;
}

template<>
vmp_bool arg_from_python<vmp_bool>(pylib::Objref *obj)
{
    try
    {
        return pylib::pylong_asbool(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp_bool>() %s",x.what()); 
    }
    return false;
}

template<>
vmp::str arg_from_python<vmp::str>(pylib::Objref *obj)
{
    try
    {
        return pylib::pyunicode_asstring(obj);
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylib::arg_from_python<vmp::str>() %s",x.what());
    }
    return "";
}

template<>
pylib::Objref *arg_from_python<pylib::Objref *>(pylib::Objref *obj)
{
    return obj;
}

}}

