/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 19/02/2024
*/
 
#include "net.h"

namespace vampiria { namespace net {

void udp_read(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    vmp::Buf buf;
    net::Address peer; 
    vmp_int ret;
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        ret=net::socket_recvFrom(conn->fd_,&buf,&peer,conn->udpmaxsize_);
        if(ret == 0)
            manager->cell_close_ok_spec(cell,"net::EventConnection");
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",errno,vmp::value_errno());
        else if(ret > 0)
            exec=manager->cell_update(cell);
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());   
    }
    manager->unlock();
    if(exec)
        conn->recvfrom_(cell,&buf,&peer);
    buf.reset();
}

void udp_connect_read(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    vmp::Buf buf;
    vmp_int ret;
    manager->lock();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        ret=net::socket_recv(conn->fd_,&buf);
        if(ret == 0)
            manager->cell_close(cell,event::SUCCESS);
        else if(ret == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",errno,vmp::value_errno());
        else if(ret > 0)
            exec=manager->cell_update(cell);
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());   
    }
    manager->unlock();
    if(exec)
        conn->recv_(cell,&buf);
    buf.reset();  
}

void connection_udp_sendto4(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    if((peer != 0) && (!peer->is_ipv4()))
        manager->cell_close_err_spec(cell,"net::EventConnection",0,"invalid ipv4 type peer address");
    if(net::socket_sendTo(conn->fd_,buf,peer) == -1)
        manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
}

void connection_udp_sendto6(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    if((peer != 0) && !peer->is_ipv6())
        manager->cell_close_err_spec(cell,"net::EventConnection",0,"invalid ipv6 type peer address");
    if(net::socket_sendTo(conn->fd_,buf,peer) == -1)
        manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
}

void connection_udp_sendto4_getaddr(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    connection_udp_sendto4(cell,buf,peer);
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        if(net::socket_addrlocal(conn->fd_,&(conn->local_)) == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    conn->sendto_=net::connection_udp_sendto4;
}

void connection_udp_sendto6_getaddr(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    connection_udp_sendto6(cell,buf,peer);
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        if(net::socket_addrlocal(conn->fd_,&(conn->local_)) == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    conn->sendto_=net::connection_udp_sendto6;
}

void connection_udp_sendto4_getaddr_s(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    connection_udp_sendto4(cell,buf,peer);
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        if(net::socket_addrlocal(conn->fd_,&(conn->local_)) == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    conn->send_=net::connection_udp_sendto4;
}

void connection_udp_sendto6_getaddr_s(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    connection_udp_sendto6(cell,buf,peer);
    event::Manager *manager=cell->get_manager();
    net::EventConnection *conn=cell->event<net::EventConnection>();
    try
    {
        if(net::socket_addrlocal(conn->fd_,&(conn->local_)) == -1)
            manager->cell_close_err_spec(cell,"net::EventConnection",vmp::get_errno(),vmp::value_errno());
    }
    catch(vmp::exception &x)
    {
        manager->cell_close_err_spec(cell,"net::EventConnection",0,x.what());
    }
    conn->send_=net::connection_udp_sendto6;
}

}}

