/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 30/01/2024
 */

#ifndef VAMPIRIA_NET_CONNECTION_CB_H

#define VAMPIRIA_NET_CONNECTION_CB_H 1

namespace vampiria { namespace net {

//! Internal usage(cb.cc)
void connection_send_noimpl(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void udp_read(event::Cell *cell);

//! Internal usage(udpcb.cc)
void udp_connect_read(event::Cell *cell);

//! Internal usage(udpcb.cc)
void connection_udp_sendto4(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void connection_udp_sendto6(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void connection_udp_sendto4_getaddr(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void connection_udp_sendto6_getaddr(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void connection_udp_sendto4_getaddr_s(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(udpcb.cc)
void connection_udp_sendto6_getaddr_s(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

//! Internal usage(tcpcb.cc)
void connection_tcp_accept(event::Cell *cell);

//! Internal usage(tcpcb.cc)
void connection_tcp_connect(event::Cell *cell);

//! Internal usage(tcpcb.cc)
void connection_tvp_recv(event::Cell *cell);

//! Internal usage(tcpcb.cc)
void connection_tcp_send(event::Cell *cell,vmp::Buf *buf,net::Address *peer);

}}

#endif

