/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/12/2023
 */

#include "event.h"

namespace vampiria { namespace event {

void breakloop_ev(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    event::EventPipe *event=cell->event<event::EventPipe>();
    vmp_byte byte;
    while(vmp::fd_read_bytes(event->fd_,&byte,1) == 1)
        manager->cell_update(cell);
    manager->unlock();
}

BreakloopUI::BreakloopUI(event::Manager *manager):event::UI(manager)
{
}
      
BreakloopUI::~BreakloopUI()
{
    manager_->cell_release(cell_);
}

void BreakloopUI::init()
{
    cell_=evtpipe_.evt_pipe_new(this, breakloop_ev,0);
    manager_->cell_alloc(cell_);
}

void BreakloopUI::active()
{
    try
    {
        vmp_byte b=0x00;
        vmp::fd_write_bytes(evtpipe_.wfd_,&b,1);
    }
    catch(vmp::exception &x)
    {
    }
}

vmp::str BreakloopUI::identity(event::Cell *cell)
{
    return "Breakloop Event";
}
      
void BreakloopUI::close_event(event::Cell *cell)
{
    evtpipe_.evt_pipe_close();
}
      
void BreakloopUI::free_ref(event::Cell *cell)
{
    evtpipe_.evt_pipe_free();
}

}}

