/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 01/03/2024
 */

#include "net_.h"

class PyTcpUI:public net::TcpUI
{
   public:
        PyTcpUI(event::Manager *manager);
        ~PyTcpUI();

        pylib::PyCall pyconnect_;
        pylib::PyCall pycrecv_;
        pylib::PyCall pycclose_;

        pylib::PyCall pyacptevent_;
        pylib::PyCall pysvlcevent_;
        pylib::PyCall pysvrevent_;
        pylib::PyCall pysvcevent_;
};

PyTcpUI::PyTcpUI(event::Manager *manager):net::TcpUI(manager)
{
}

PyTcpUI::~PyTcpUI()
{
}

struct stub_tcpui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyTcpUI *>(cell->ui<PyTcpUI>(),false);

        }
        return 0;
    }
};

struct TcpUI_Constructor:public pylib::Constructor<PyTcpUI>
{
    PyTcpUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyTcpUI(manager);
         }
         return 0;
    }
};

void tcp_pyconnect(event::Cell *cell)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    tcpui->pyconnect_.call(cargs);
}

void tcp_pycrecv(event::Cell *cell,vmp::Buf *buf)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    tcpui->pycrecv_.call(cargs);
}

void tcp_pycclose(event::Cell *cell)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    tcpui->pycclose_.call(cargs);
}

struct stub_TcpUI_set_event_client:public pylib::Member_def<PyTcpUI>
{
    pylib::Objref *def(PyTcpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            event::EVTCB      connect;
            event::EVTCBBUF   crecv;
            event::EVTCB      cclose;
            
            args.get_callable(0,instance->pyconnect_);
            args.get_callable(1,instance->pycrecv_);
            args.get_callable(2,instance->pycclose_);
            
            if(pylib::is_none(instance->pyconnect_.ref()))
                connect=0;
            else 
                connect=tcp_pyconnect;
            if(pylib::is_none(instance->pycrecv_.ref()))
                crecv=0;
            else 
                crecv=tcp_pycrecv;
            if(pylib::is_none(instance->pycclose_.ref()))
                cclose=0;
            else 
                cclose=tcp_pycclose;
            instance->set_event_client(connect,crecv,cclose);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void tcp_pyacptevent(event::Cell *listen,event::Cell *server)
{
    PyTcpUI *tcpui=listen->ui<PyTcpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(listen,false);
    cargs.add<event::Cell *>(server,false);
    tcpui->pyacptevent_.call(cargs);
}

void tcp_pysvlcevent(event::Cell *cell)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    tcpui->pysvlcevent_.call(cargs);
}

void tcp_pysvrevent(event::Cell *cell,vmp::Buf *buf)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    tcpui->pysvrevent_.call(cargs);
}

void tcp_pysvcevent(event::Cell *cell)
{
    PyTcpUI *tcpui=cell->ui<PyTcpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    tcpui->pysvcevent_.call(cargs);
}

struct stub_TcpUI_set_event_server:public pylib::Member_def<PyTcpUI>
{
    pylib::Objref *def(PyTcpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            net::EVTCBACCEPT  acptevent;
            event::EVTCB      svlcevent; 
            event::EVTCBBUF   svrevent;
            event::EVTCB      svcevent;
            
            args.get_callable(0,instance->pyacptevent_);
            args.get_callable(1,instance->pysvlcevent_);
            args.get_callable(2,instance->pysvrevent_);
            args.get_callable(3,instance->pysvcevent_);
            
            if(pylib::is_none(instance->pyacptevent_.ref()))
                acptevent=0;
            else 
                acptevent=tcp_pyacptevent;
            if(pylib::is_none(instance->pysvlcevent_.ref()))
                svlcevent=0;
            else 
                svlcevent=tcp_pysvlcevent;
            if(pylib::is_none(instance->pysvrevent_.ref()))
                svrevent=0;
            else 
                svrevent=tcp_pysvrevent;
            if(pylib::is_none(instance->pysvcevent_.ref()))
                svcevent=0;
            else 
                svcevent=tcp_pysvcevent;
            instance->set_event_server(acptevent,svlcevent,svrevent,svcevent);
            return pylib::retnone();                      
        }
        return 0;
    }
};

struct stub_TcpUI_new_client:public pylib::Member_def<PyTcpUI>
{
    pylib::Objref *def(PyTcpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            net::Address *peer=args.get<net::Address *>(0);
            return pylib::Converter<event::Cell *>(instance->new_client(peer),false);
        }
        else if(args.size() == 2)
        {
            net::Address *peer=args.get<net::Address *>(0);
            net::ProxyInfo *proxy=0;
            if(!args.is_none(1))
                proxy=args.get<net::ProxyInfo *>(1);
            return pylib::Converter<event::Cell *>(instance->new_client(peer,proxy),false);
        }
        return 0;
    }
};
    
void net_init_tcpui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("tcpui",stub_tcpui());
    
    //net/tcp.h
    pylib::Class<PyTcpUI> tcpui=module.class_with_constructor<PyTcpUI>("TcpUI",TcpUI_Constructor());
    tcpui.def_with_stub("set_event_client",stub_TcpUI_set_event_client());
    tcpui.def_with_stub("set_event_server",stub_TcpUI_set_event_server());
    tcpui.def_("new_server",&PyTcpUI::new_server,false);
    tcpui.def_with_stub("new_client",stub_TcpUI_new_client());
    tcpui.def_("send",&PyTcpUI::send);
    tcpui.def_("localaddr",&PyTcpUI::localaddr,false);
    tcpui.def_("peeraddr",&PyTcpUI::peeraddr,false);
    tcpui.def_("proxyinfo",&PyTcpUI::proxyinfo,false);
    tcpui.def_("connection_type",&PyTcpUI::connection_type);
    tcpui.def_("connection_strtype",&PyTcpUI::connection_strtype);
}

