/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 15/03/2024
 */

#include "vmp.h"
#include "pylib.h"
#include "net.h"

#ifndef VAMPIRIA_PY_NET_H

#define VAMPIRIA_PY_NET_H 1

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/address.h:<BR>is_ipv4_raw(),ipv4_expand(),is_ipv6_raw(),is_ip_raw(),ip_to_buf(),ipv4_from_buf(),ipv6_from_buf(),
    is_macaddress_raw(),macaddress_to_buf(),macaddress_from_buf()
*/
/*!
    Const c++ in net/connection.h:<BR>CONN_NONE,CONN_UDP4,CONN_UDP6,CONN_UDPCONNECT,CONN_UDPPROXY
                 CONN_TCPSERVER,CONN_TCPCLIENT,CONN_TCPPROXY    
                 
*/
/*!
    Const c++ in net/connection.h:<BR>conn_strtype()
*/
//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    ProxyInfo Class in net/connection.h:<BR>Constructor ProxyInfo()<BR>
    ProxyInfo member function list:<BR>reset(),addr()
*/
/*!
    Const c++ in net/socket.h:<BR>UDP_MSIZE_DEFAULT
*/
/*!
    Function c++ in net/socket.h:<BR>
             socket_datagram(),socket_stream(),socket_connect_check(),
             socket_bind(),socket_listen(),socket_accept(),socket_addrlocal(),
             socket_addrpeer(),socket_close(),socket_timeout(),socket_recvFrom(),
             socket_recv(),socket_sendTo(),socket_send()
*/
/*!
    Function c++ in net/dns.h:<BR>tcp_resolve4(),tcp_resolve6(),tcp_resolveMX()
*/
void net_init(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::Address in vmp_net.Address(see c++ doc)
/*!
    Address class in net/address.h:<BR>Constructor Address() or Address(dnstype,dnsip) or Address(dnstype,dnsip,dnsport) or Address(dnstype,dnsip,dnsport,dnstout)<BR>
    Address member function list:<BR>reset(),set(),set_ip_raw(),copy(),host(),ip(),service(),is_ipv4(),is_ipv6(),onlyhost()
*/
void net_init_address(pylib::Module module);

//!Python wrapper of the c++ class vampiria::net::MacAddress in vmp_net.MacAddress(see c++ doc)
/*!
    MacAddress class in net/address.h:<BR>Constructor MacAddress()<BR>
    MacAddress member function list:<BR>reset(),set(),str_addr(),byte_addr()
*/
void net_init_macaddress(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::net in vmp_net.(see c++ doc)
/*!
    Function c++ in net/netdevice.h:<BR>iface_mac(),iface_ipv4(),iface_ipv4_netmask(),iface_ipv4_broadcast(),iface_ipv4_mtu()
*/
void net_init_netdevice(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::UdpUI in vmp_net.UdpUI(see c++ doc)
/*!
    Wrapper Cell->ui() for udp in udpui(cell)<BR>
    @return user interface udp ui for cell.(The cell must be built with the UdpUI user interface)
*/
/*!
    UdpUI Class in net/udp.h:<BR>Constructor UdpUI(manager)<BR>
    UdpUI member function list:<BR>
      set_event(),new_bind(),new_udp4(),new_udp6(),new_client(),sendTo(),
      send(),maxpsize(),localaddr(),peeraddr(),proxyinfo(),connection_type(),
      connection_strtype()
*/
void net_init_udpui(pylib::Module module);

//!Python wrapper of  of the c++ class vampiria::net::TcpUI in vmp_net.TcpUI(see c++ doc)
/*!
    Wrapper Cell->ui() for tcp in tcpui(cell)<BR>
    @return user interface tcp ui for cell.(The cell must be built with the TcpUI user interface)
*/
/*!
    TcpUI Class in net/tcp.h:<BR>Constructor TcpUI(manager)<BR>
    TcpUI member function list:<BR>set_event_client(),set_event_server(),new_client(),new_server(),send(),localaddr(),peeraddr(),
         proxyinfo(),connection_type()
*/
void net_init_tcpui(pylib::Module module);

#endif

