/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 04/04/2024
 */

#include "json_.h"

struct Status_stub_Constructor:public pylib::Constructor<json::Status>
{
    json::Status *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str dirpath=args.get<vmp::str>(0);
            return new json::Status(dirpath);
        }
        else if(args.size() == 2)
        {
            vmp::str dirpath=args.get<vmp::str>(0);
            vmp_bool cache=args.get<vmp_bool>(1);
            return new json::Status(dirpath,cache);  
        }
        else if(args.size() == 3)
        {
            vmp::str dirpath=args.get<vmp::str>(0);
            vmp_bool cache=args.get<vmp_bool>(1);
            vmp::str id=args.get<vmp::str>(2);
            return new json::Status(dirpath,cache,id);  
        }
        return 0;
    }
};

struct stub_status_keys:public pylib::Member_def<json::Status>
{
    pylib::Objref *def(json::Status *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::vector<vmp::str >>(instance->keys());
        else if(args.size() == 1)
        {
            vmp::str jtype=args.get<vmp::str>(0);
            return pylib::Converter<vmp::vector<vmp::str >>(instance->keys(jtype));
        }
        return 0;
    }
};

struct stub_status_request_close:public pylib::Member_def<json::Status>
{
    pylib::Objref *def(json::Status *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str jreqkey=args.get<vmp::str>(0);
            vmp_int status=args.get<vmp_int>(1);
            instance->request_close(jreqkey,status);
            return pylib::retnone();
        }
        else if(args.size() == 1)
        {
            vmp::str jreqkey=args.get<vmp::str>(0);
            vmp_int status=args.get<vmp_int>(1);
            vmp::str msg=args.get<vmp::str>(2);
            instance->request_close(jreqkey,status,msg);
            return pylib::retnone();
        }
        return 0;
    }
};

void json_status(pylib::Module module)
{
    module.def_("status_input",json::status_input);
    module.def_("status_response",json::status_response);
    
    pylib::Class<json::Status> status=module.class_with_constructor<json::Status>("Status",Status_stub_Constructor());
    status.def_("root",&json::Status::root,false);
    status.def_("backup",&json::Status::backup);
    status.def_with_stub("keys",stub_status_keys());
    status.def_("update",&json::Status::update);
    status.def_("update_from_japi",&json::Status::update_from_japi);
    status.def_("cancel",&json::Status::cancel);
    status.def_("cancel_from_japi",&json::Status::cancel_from_japi);
    status.def_("search",&json::Status::search);
    status.def_("request_open",&json::Status::request_open);
    status.def_with_stub("request_close",stub_status_request_close());
}
