/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 15/03/2024
*/

#include "json_.h"

struct stub_jrpreqsession_add_reqdata:public pylib::Member_def<json::jrp::JrpReqSession>
{
    pylib::Objref *def(json::jrp::JrpReqSession *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 3)
        {
            vmp::str input=args.get<vmp::str>(0);
            vmp::vector<vmp::str> push=args.get<vmp::vector<vmp::str> >(1);
            vmp::vector<vmp::str> response=args.get<vmp::vector<vmp::str> >(2);
            instance->add_reqdata(input,push,response);
            return pylib::retnone();
            
        }
        else if(args.size() == 4)
        {
            vmp::str input=args.get<vmp::str>(0);
            vmp::vector<vmp::str> push=args.get<vmp::vector<vmp::str> >(1);
            vmp::vector<vmp::str> response=args.get<vmp::vector<vmp::str> >(2);
            vmp::str permits=args.get<vmp::str>(3);
            instance->add_reqdata(input,push,response,permits);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_jrpreqsession_search_reqdata:public pylib::Member_def<json::jrp::JrpReqSession>
{
    pylib::Objref *def(json::jrp::JrpReqSession *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str input=args.get<vmp::str>(0);
            json::jrp::JrpReqData *ret=instance->search_reqdata(input);
            if(ret == 0)
                return pylib::retnone();
            return pylib::Converter<json::jrp::JrpReqData *>(ret,false); 
        }
        return 0;
    }
};

struct stub_jrpreq_close:public pylib::Member_def<json::jrp::JrpReq>
{
    pylib::Objref *def(json::jrp::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_int status=args.get<vmp_int>(0);
            instance->close(status);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            vmp_int status=args.get<vmp_int>(0);
            vmp::str msg=args.get<vmp::str>(1);
            instance->close(status,msg);
            return pylib::retnone();
        } 
        return 0;
    }  
};

void json_jrp(pylib::Module module)
{
    pylib::Module jrp=module.add_submodule("jrp");
    jrp.add_const<vmp_int>("status_ok",json::jrp::status_ok);
    jrp.add_const<vmp_int>("status_err",json::jrp::status_err);
    jrp.add_const<vmp_int>("status_malformed_msg",json::jrp::status_malformed_msg);
    jrp.add_const<vmp_int>("status_undef_datatype",json::jrp::status_undef_datatype);
    jrp.add_const<vmp_int>("status_accessdenied",json::jrp::status_accessdenied);
    jrp.add_const<vmp_int>("status_duplexsession",json::jrp::status_duplexsession);
    jrp.add_const<vmp_int>("status_protocolbad",json::jrp::status_protocolbad);
    jrp.add_const<vmp_int>("status_closeconnection",json::jrp::status_closeconnection);
    jrp.add_const<vmp_int>("status_timeout",json::jrp::status_timeout);
    jrp.add_const<vmp_int>("status_killed",json::jrp::status_killed);
    jrp.add_const<vmp_int>("status_input_bad",json::jrp::status_input_bad);
    jrp.add_const<vmp_int>("status_push_bad",json::jrp::status_push_bad);
    jrp.add_const<vmp_int>("status_input_notmanaged",json::jrp::status_input_notmanaged);
    jrp.add_const<vmp_int>("status_rid_duplex",json::jrp::status_rid_duplex);
    jrp.add_const<vmp_int>("status_resource_busy",json::jrp::status_resource_busy);
    jrp.add_const<vmp_int>("status_resource_accessdenied",json::jrp::status_resource_accessdenied);
    
    jrp.def_("msg_status",json::jrp::msg_status);
    
    jrp.add_const<vmp_index>("min_permits",json::jrp::min_permits);
    jrp.add_const<vmp_index>("max_permits",json::jrp::max_permits);
    
    pylib::Class<json::jrp::JrpReqData> jrpreqdata=jrp.class_no_constructor<json::jrp::JrpReqData>("JrpReqData");
    jrpreqdata.def_("input",&json::jrp::JrpReqData::input);
    jrpreqdata.def_("push",&json::jrp::JrpReqData::push);
    jrpreqdata.def_("response",&json::jrp::JrpReqData::response);
    jrpreqdata.def_("permits_s",&json::jrp::JrpReqData::permits_s);
    jrpreqdata.def_("permits",&json::jrp::JrpReqData::permits);
    
    pylib::Class<json::jrp::JrpReqSession> jrpreqsession=jrp.class_<json::jrp::JrpReqSession>("JrpReqSession");
    jrpreqsession.def_("reset",&json::jrp::JrpReqSession::reset);
    jrpreqsession.def_("permits",&json::jrp::JrpReqSession::permits);
    jrpreqsession.def_("match_reqdata",&json::jrp::JrpReqSession::match_reqdata);
    jrpreqsession.def_with_stub("add_reqdata",stub_jrpreqsession_add_reqdata());
     jrpreqsession.def_with_stub("search_reqdata",stub_jrpreqsession_search_reqdata());
    jrpreqsession.def_("all_input",&json::jrp::JrpReqSession::all_input);
    jrpreqsession.def_("search_push",&json::jrp::JrpReqSession::search_push);
    jrpreqsession.def_("search_response",&json::jrp::JrpReqSession::search_response);
    
    pylib::Class<json::jrp::JrpReq> jrpreq=jrp.class_no_constructor<json::jrp::JrpReq>("JrpReq");
    jrpreq.def_("type",&json::jrp::JrpReq::type);
    jrpreq.def_("cell",&json::jrp::JrpReq::cell,false);
    jrpreq.def_("rid",&json::jrp::JrpReq::rid);
    jrpreq.def_("jdata_type",&json::jrp::JrpReq::jdata_type);
    jrpreq.def_("key",&json::jrp::JrpReq::key);
    jrpreq.def_("jdata_json",&json::jrp::JrpReq::jdata_json,false);
    jrpreq.def_("jdata_root",&json::jrp::JrpReq::jdata_root,false);
    jrpreq.def_("status",&json::jrp::JrpReq::status);
    jrpreq.def_("msg",&json::jrp::JrpReq::msg);
    jrpreq.def_("alloc_internal",&json::jrp::JrpReq::alloc_internal);
    jrpreq.def_("alloc",&json::jrp::JrpReq::alloc);
    jrpreq.def_("release_internal",&json::jrp::JrpReq::release_internal);
    jrpreq.def_("release",&json::jrp::JrpReq::release);
    jrpreq.def_("push",&json::jrp::JrpReq::push);
    jrpreq.def_("response",&json::jrp::JrpReq::response);
    jrpreq.def_("kill",&json::jrp::JrpReq::kill);
    jrpreq.def_with_stub("close",stub_jrpreq_close());
    jrpreq.def_("request_oper",&json::jrp::JrpReq::request_oper);
    jrpreq.def_("kill_oper",&json::jrp::JrpReq::kill_oper);
    jrpreq.def_("send_from_oper",&json::jrp::JrpReq::send_from_oper);
}

