/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 04/02/2023
 */
 
#ifndef VAMPIRIA_PY_EVENT_PROCESS_H

#define VAMPIRIA_PY_EVENT_PROCESS_H 1

//!Event Process(internal usage)
class EventProcess:public event::Event
{
    public:
        //!A Constructor
        EventProcess();

        //!A Destructor
        ~EventProcess();

        vmp::str appname_;/*!<Application name*/
        vmp_int pid_;/*!<Pid of the application process*/
        pylib::PyObj proc_;/*!<Python Object process*/
        pylib::PyObj pipe_;/*!<Python Object pipe(signal main process)*/
        
        //! Reset event
        void reset();
};

//! User interface on the c++ side of python processes (coupled with a pure python class,internal usage)
class ProcessUI:public event::UI
{
    public:
        vmp::utils::Storage<EventProcess> pref_;/*!<Storage event*/
        pylib::PyObj pyui_;/*!<Python user interface references*/
        pylib::PyCall close_pyobj_;/*!<Python join process function and close python pye(Used in close_event).*/
        pylib::PyCall read_msg_;/*!<Python recv_msg process function(Used in callback read and call in python callback recv).*/
        pylib::PyCall close_;/*!<Python close callback*/

        //!A Constructor
        /*!
            @param manager input manager
        */
        ProcessUI(event::Manager *manager);
        
        //! A Destructor
        ~ProcessUI();

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);
};

//! User interface used in the child process to insert the communication pipe reading in a data manager(internal usage with python App)
class AppUI:public event::UI
{
    public:
        //!A Constructor
        /*!
            @param manager input manager
        */
        AppUI(event::Manager *manager);

        //! A Destructor
        ~AppUI();

        event::Event evt_;/*!<Event associated*/
        pylib::PyObj pyui_;/*!<Python user interface references*/
        pylib::PyCall read_msg_;/*!<Python recv_msg process function(Used in callback read and call in python callback recv).*/
        pylib::PyCall close_;/*!<Python close callback*/
        vmp_int fd_;/*!<Filedescriptor used by the event*/
        vmp::str appname_;/*!<Application name*/
        event::Cell *cell_;/*!<Cell references*/

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);

        //!Event app
        event::Cell *event();
};

#endif

