/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 04/01/2023
 */

#include "vmp_.h"

struct stub_ctime_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 0)
             return pylib::Converter<vmp::str>(vmp::time::ctime_wrap());
         else if(args.size() == 1)
         {
             vmp_uint time=args.get<vmp_uint>(0);
             return pylib::Converter<vmp::str>(vmp::time::ctime_wrap(time));    
         }
         return 0;
    }
};

struct stub_gmtime_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 0)
             return pylib::Converter<vmp::str>(vmp::time::gmtime_wrap());
         else if(args.size() == 1)
         {
             vmp_uint time=args.get<vmp_uint>(0);
             return pylib::Converter<vmp::str>(vmp::time::gmtime_wrap(time));    
         }
         return 0;
    }
};

struct Localtime_stub_Constructor:public pylib::Constructor<vmp::time::Localtime>
{
    vmp::time::Localtime *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return new vmp::time::Localtime();
        else if(args.size() == 1)
        {
            vmp_uint time=args.get<vmp_uint>(0);
            return new vmp::time::Localtime(time);
        }
        else if(args.size() == 6)
        {
            vmp_int year_v=args.get<vmp_int>(0);
            vmp_int month_v=args.get<vmp_int>(1);
            vmp_int day_v=args.get<vmp_int>(2);
            vmp_int hour_v=args.get<vmp_int>(3);
            vmp_int min_v=args.get<vmp_int>(4);
            vmp_int sec_v=args.get<vmp_int>(5);
            return new vmp::time::Localtime(year_v,month_v,day_v,hour_v,min_v,sec_v);
        }
        return 0;
    }
};

struct stub_localtime_set:public pylib::Member_def<vmp::time::Localtime>
{
    pylib::Objref *def(vmp::time::Localtime *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp_uint>(instance->set());
        else if(args.size() == 1)
        {
            vmp_uint time=args.get<vmp_uint>(0);
            return pylib::Converter<vmp_uint>(instance->set(time));
        }
        else if(args.size() == 6)
        {
            vmp_int year_v=args.get<vmp_int>(0);
            vmp_int month_v=args.get<vmp_int>(1);
            vmp_int day_v=args.get<vmp_int>(2);
            vmp_int hour_v=args.get<vmp_int>(3);
            vmp_int min_v=args.get<vmp_int>(4);
            vmp_int sec_v=args.get<vmp_int>(5);
            return pylib::Converter<vmp_uint>(instance->set(year_v,month_v,day_v,hour_v,min_v,sec_v));
        }
        return 0;
    }
};

void vmp_init_time(pylib::Module module)
{
    pylib::Module time=module.add_submodule("time");

    //vmp/time.h
    time.def_("vsleep",vmp::time::vsleep);
    time.def_("time_wrap",vmp::time::time_wrap);
    time.def_with_stub("ctime_wrap",stub_ctime_wrap());
    time.def_with_stub("gmtime_wrap",stub_gmtime_wrap());
    
    pylib::Class<vmp::time::Localtime> localtime=time.class_with_constructor<vmp::time::Localtime>("Localtime",Localtime_stub_Constructor());
    localtime.def_with_stub("set",stub_localtime_set());
    localtime.def_("get_year_days",&vmp::time::Localtime::get_year_days);
    localtime.def_("set_from_year_day",&vmp::time::Localtime::set_from_year_day);
    localtime.def_("next_cronizer",&vmp::time::Localtime::next_cronizer);
    localtime.def_("time",&vmp::time::Localtime::time);
    localtime.def_("sec",&vmp::time::Localtime::sec);
    localtime.def_("min",&vmp::time::Localtime::min);
    localtime.def_("hour",&vmp::time::Localtime::hour);
    localtime.def_("mday",&vmp::time::Localtime::mday);
    localtime.def_("wday",&vmp::time::Localtime::wday);
    localtime.def_("wday_n",&vmp::time::Localtime::wday_n);
    localtime.def_("month",&vmp::time::Localtime::month);
    localtime.def_("month_n",&vmp::time::Localtime::month_n);
    localtime.def_("year",&vmp::time::Localtime::year);
    localtime.def_("ctime",&vmp::time::Localtime::ctime);
    localtime.def_("gmtime",&vmp::time::Localtime::gmtime);
    localtime.def_("year_day",&vmp::time::Localtime::year_day);
    
    pylib::Class<vmp::time::Timer> timer=time.class_<vmp::time::Timer>("Timer");
    timer.def_("init",&vmp::time::Timer::init);
    timer.def_("now",&vmp::time::Timer::now);
}

