/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 24/01/2023
 */

#include "vmp_.h"

struct stub_blocking_unblock:public pylib::Member_def<vmp::thread::Blocking>
{
    pylib::Objref *def(vmp::thread::Blocking *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            instance->unblock();
        else if(args.size() == 1)
        {
            vmp_byte b=args.get<vmp_byte>(0);
            instance->unblock(b);
        }
        else
            return 0;
        return pylib::retnone();
    }
};

void vmp_init_thread(pylib::Module module)
{
    pylib::Module thread=module.add_submodule("thread");
    
    pylib::Class<vmp::thread::Mutex> mutex=thread.class_<vmp::thread::Mutex>("Mutex");
    mutex.def_("lock",&vmp::thread::Mutex::lock);
    mutex.def_("unlock",&vmp::thread::Mutex::unlock);
    mutex.def_("forced_unlock",&vmp::thread::Mutex::forced_unlock);
    mutex.def_("recovery_lock",&vmp::thread::Mutex::recovery_lock);

    pylib::Class<vmp::thread::Blocking> blocking=thread.class_<vmp::thread::Blocking>("Blocking");
    blocking.def_("pause",&vmp::thread::Blocking::pause);
    blocking.def_with_stub("unblock",stub_blocking_unblock());
}

