/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 14/11/2023
 */

#include "vmp_.h"

struct stub_union_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
         {
             arg0=args.get<vmp::str>(0);     
         }
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::fs::union_path(arg0,arg1));
   }
};

void vmp_init_fs(pylib::Module module)
{
    pylib::Module fs=module.add_submodule("fs");
    
    //vmp/lib.h
    fs.def_("unlink_wrap",vmp::fs::unlink_wrap);
    fs.def_("format_dirpath",vmp::fs::format_dirpath);
    fs.def_with_stub("union_path",stub_union_path());
    fs.def_("chmod_wrap",vmp::fs::chmod_wrap);
    fs.def_("mkdir_wrap",vmp::fs::mkdir_wrap);
    fs.def_("rmdir_wrap",vmp::fs::rmdir_wrap);
    fs.def_("chdir_wrap",vmp::fs::chdir_wrap);
    fs.def_("isdir",vmp::fs::isdir);
    fs.def_("isrdir",vmp::fs::isrdir);
    fs.def_("iswdir",vmp::fs::iswdir);
    fs.def_("isxdir",vmp::fs::isxdir);
    fs.def_("getcwd_wrap",vmp::fs::getcwd_wrap);
    fs.def_("listendir",vmp::fs::listendir);
    fs.def_("isfile",vmp::fs::isfile);
    fs.def_("isrfile",vmp::fs::isrfile);
    fs.def_("iswfile",vmp::fs::iswfile);
    fs.def_("isxfile",vmp::fs::isxfile);
}

