/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/03/2023
 */

#include "vmp_.h"

struct stub_vampiria_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         if(args.size() == 0)
             arg0="";
         else if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::vampiria_path(arg0));
   }
};

struct stub_vampiria_frm:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         if(args.size() == 0)
             arg0="";
         else if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::vampiria_frm(arg0));
   }
};

struct stub_vampiria_cache:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         if(args.size() == 0)
             arg0="";
         else if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::vampiria_cache(arg0));
   }
};

struct stub_vampiria_home:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         if(args.size() == 0)
             arg0="";
         else if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::vampiria_home(arg0));
   }
};

struct stub_software_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::software_path(arg0,arg1));
   }
};

struct stub_module_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::module_path(arg0,arg1));
   }
};

struct stub_pkg_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::pkg_path(arg0,arg1));
   }
};

struct stub_vpkg_path:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str arg0;
         vmp::str arg1="";
         if(args.size() == 1)
             arg0=args.get<vmp::str>(0);     
         else if(args.size() == 2)
         {
             arg0=args.get<vmp::str>(0);
             arg1=args.get<vmp::str>(1);
         }
         else
             return 0;
         return pylib::Converter<vmp::str>(vmp::env::vpkg_path(arg0,arg1));
   }
};

void vmp_init_env(pylib::Module module)
{
    //vmp/env.h
    pylib::Module env=module.add_submodule("env");
    
    env.def_("author",vmp::env::author);
    env.def_("email",vmp::env::email);
    env.def_("webpage",vmp::env::webpage);
    env.def_("license",vmp::env::license);
    env.def_("version",vmp::env::version);
    env.def_with_stub("vampiria_path",stub_vampiria_path());
    env.def_with_stub("vampiria_frm",stub_vampiria_frm());
    env.def_("vampiria_bin",vmp::env::vampiria_bin);
    env.def_("vampiria_lib",vmp::env::vampiria_lib);
    env.def_with_stub("vampiria_cache",stub_vampiria_cache());
    env.def_with_stub("vampiria_home",stub_vampiria_home());    
    env.def_("software_root",vmp::env::software_root);
    env.def_with_stub("software_path",stub_software_path());
    env.def_("software_isinstalled",vmp::env::software_isinstalled);
    env.def_("modules_root",vmp::env::modules_root);
    env.def_with_stub("module_path",stub_module_path());
    env.def_("module_main_path",vmp::env::module_main_path);
    env.def_("module_manifest",vmp::env::module_manifest);
    env.def_("module_isinstalled",vmp::env::module_isinstalled);
    env.def_with_stub("pkg_path",stub_pkg_path());
    env.def_with_stub("vpkg_path",stub_vpkg_path());
    env.def_("frm_dtd",vmp::env::frm_dtd);
    env.def_("python_exe",vmp::env::python_exe);
    env.def_("python_env",vmp::env::python_env);
    env.def_("python_moduleimp",vmp::env::python_moduleimp);
    env.def_("python_main",vmp::env::python_main);
    env.def_("python_software_main",vmp::env::python_software_main);
    env.def_("python_files_check",vmp::env::python_files_check);
    env.def_("xml_hdr",vmp::env::xml_hdr);
    env.def_("format_path",vmp::env::format_path);
}

