#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 27/03/2019

import vmpconfig   as config
import vmpbuild    as build
import vmppybuild  as pybuild

##software name
name="example_py"

##for exe c++; see example_c for config
setup=build.setup()
setup.name=name
setup.path=config.gsoftware_path(name)
setup.files=[('./exe/',['main'])]
setup.dirtarget=config.gexec_
setup.dependencies=['vmp','process']

##To build a library to interface with python use build.setup() with shared option = true 

##build pysetup object
pysetup=pybuild.pysetup()

##directory path with main.py file
pysetup.dirmain=config.gsoftware_path(name)

##framework python dependencies('vmp' is added by default)
pysetup.dependencies=[]

##command verify ['xterm -h',....]
#pysetup.cmd=[]

def description():
    return "description software"

##Install
def install():
    build.cbuild(setup)
    pybuild.pybuild(pysetup)

##Remove
def uninstall():
    build.cclear(setup)
    pybuild.pyclear(pysetup)
    
