#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 10/10/2023

import vmplib    as lib
import vmppylib  as pylib
import vmpsys    as sys
import vmpconfig as config

lib.included_.append(sys.path(config.gpkg_))

db0=lib.clib()
db0.name='db0'
db0.dependencies=['vmp']
db0.pkg=True
db0.cmd=[]
db0.files=[('db/',['db'])]
db0.libs=[('sqlite3','3.40.1')]
db0.loptions=['`pkg-config sqlite3 --cflags --libs`']
lib.clibs_[db0.name]=db0

xterm0=lib.clib()
xterm0.name='xterm0'
xterm0.dependencies=['vmp']
xterm0.pkg=True
xterm0.files=[('xterm/',['xterm'])]
xterm0.cmd=['xterm -h']
lib.clibs_[xterm0.name]=xterm0

rawnet3=lib.clib()
rawnet3.name='rawnet3'
rawnet3.dependencies=['vmp','packet','event','net']
rawnet3.pkg=True
rawnet3.files=[('rawnet/',['arpui','lib','rawnet','rawevent','rawui'])]
rawnet3.libs=[('libpcap','1.10.3')]
rawnet3.coptions=['`pkg-config --cflags libpcap`']
rawnet3.loptions=['`pkg-config --libs  libpcap`']
lib.clibs_[rawnet3.name]=rawnet3

openssl3=lib.clib()
openssl3.name='openssl3'
openssl3.dependencies=['vmp','net','event','json','db0']
openssl3.pkg=True
openssl3.cmd=['openssl version','chmod --version','cp --version']
openssl3.files=[('openssl/',['lib','hash','openssl','x509','pkey','sslevent','sslui']),('openssl/ctx/',['ctx','base','https','peer']),('openssl/jrp/',['cb','jrp','jrpevent'])]
openssl3.libs=[('openssl','3.0.9')]
openssl3.loptions=['`pkg-config --libs  openssl`']
lib.clibs_[openssl3.name]=openssl3

vmp_db0=pylib.pylib()
vmp_db0.name='vmp_db0'
vmp_db0.dependencies=['vmp']
vmp_db0.pkg=True
vmp_db0.cbuild()
vmp_db0.setup.files=[('./',['db_'])]
vmp_db0.setup.dependencies=['pylib','db0']
pylib.pylibs_[vmp_db0.name]=vmp_db0

vmp_xterm0=pylib.pylib()
vmp_xterm0.name='vmp_xterm0'
vmp_xterm0.dependencies=[]
vmp_xterm0.pkg=True
vmp_xterm0.cbuild()
vmp_xterm0.setup.files=[('./',['xterm_'])]
vmp_xterm0.setup.dependencies=['pylib','xterm0','vmp']
pylib.pylibs_[vmp_xterm0.name]=vmp_xterm0

vmp_gui0=pylib.pylib()
vmp_gui0.name='vmp_gui0'
vmp_gui0.dependencies=[]
vmp_gui0.pkg=True
pylib.pylibs_[vmp_gui0.name]=vmp_gui0

vmp_openssl3=pylib.pylib()
vmp_openssl3.name='vmp_openssl3'
vmp_openssl3.dependencies=['vmp','vmp_net','vmp_event']
vmp_openssl3.pkg=True
vmp_openssl3.cbuild()
vmp_openssl3.setup.files=[('./',['openssl_','hash_','pkey_','x509_','sslui_','ctx_','jrp_'])]
vmp_openssl3.setup.dependencies=['pylib','openssl3']
pylib.pylibs_[vmp_openssl3.name]=vmp_openssl3

vmp_rawnet3=pylib.pylib()
vmp_rawnet3.name='vmp_rawnet3'
vmp_rawnet3.dependencies=['vmp','vmp_event','vmp_packet']
vmp_rawnet3.pkg=True
vmp_rawnet3.cbuild()
vmp_rawnet3.setup.files=[('./',['arpui_','rawnet_','rawui_'])]
vmp_rawnet3.setup.dependencies=['pylib','rawnet3']
pylib.pylibs_[vmp_rawnet3.name]=vmp_rawnet3



