/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 01/07/2022
 */
 
#include "openssl_.h"

struct stub_x509_issuer:public pylib::Member_def<openssl::pkg::X509_Wrap>
{
    pylib::Objref *def(openssl::pkg::X509_Wrap *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::str>(instance->issuer());
        else if(args.size() == 1)
        {
            vmp::str field=args.get<vmp::str>(0);
            return pylib::Converter<vmp::str>(instance->issuer(field));
        }
        return 0;
    }
};

struct stub_x509_subject:public pylib::Member_def<openssl::pkg::X509_Wrap>
{
    pylib::Objref *def(openssl::pkg::X509_Wrap *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::str>(instance->subject());
        else if(args.size() == 1)
        {
            vmp::str field=args.get<vmp::str>(0);
            return pylib::Converter<vmp::str>(instance->subject(field));
        }
        return 0;
    }
};

void openssl_x509(pylib::Module module)
{
    pylib::Class<openssl::pkg::X509_Wrap> x509=module.class_<openssl::pkg::X509_Wrap>("X509_Wrap");
    x509.def_("reset",&openssl::pkg::X509_Wrap::reset);
    x509.def_("set_from_file",&openssl::pkg::X509_Wrap::set_from_file);
    x509.def_("parent",&openssl::pkg::X509_Wrap::parent,false);
    x509.def_("version",&openssl::pkg::X509_Wrap::version);
    x509.def_("serial",&openssl::pkg::X509_Wrap::serial);
    x509.def_("signature_info",&openssl::pkg::X509_Wrap::signature_info);
    x509.def_with_stub("issuer",stub_x509_issuer());
    x509.def_("validity_before",&openssl::pkg::X509_Wrap::validity_before);
    x509.def_("validity_after",&openssl::pkg::X509_Wrap::validity_after);
    x509.def_with_stub("subject",stub_x509_subject());
    x509.def_("pubkey",&openssl::pkg::X509_Wrap::pubkey);
    x509.def_("id_issuer",&openssl::pkg::X509_Wrap::id_issuer);
    x509.def_("id_subject",&openssl::pkg::X509_Wrap::id_subject);
    x509.def_("extensions",&openssl::pkg::X509_Wrap::extensions);
    x509.def_("signature_data",&openssl::pkg::X509_Wrap::signature_data);
    x509.def_("fingerprint_sha1",&openssl::pkg::X509_Wrap::fingerprint_sha1);
    x509.def_("fingerprint_sha256",&openssl::pkg::X509_Wrap::fingerprint_sha256);
    x509.def_("verify",&openssl::pkg::X509_Wrap::verify);
}

